import streamlit as st
from graphviz import Digraph 


st.markdown("""
# 👋 Two easy ways to turbo boost your AI learning journey! 💻
# 🌐 AI Pair Programming 
## Open 2 Browsers to:
1. __🌐 ChatGPT__ [URL](https://chat.openai.com/chat) or [URL2](https://platform.openai.com/playground) and 
2. __🌐 Huggingface__ [URL](https://huggingface.co/awacke1)  in separate browser windows.
1. 🤖 Use prompts to generate a streamlit program on Huggingface or locally to test it.
2. 🔧 For advanced work, add Python 3.10 and VSCode locally, and debug as gradio or streamlit apps.
3. 🚀 Use these two superpower processes to reduce the time it takes you to make a new AI program! ⏱️
# 🎥 YouTube University Method:
1. 🏋️‍♀️ Plan two hours each weekday to exercise your body and brain.
2. 🎬 Make a playlist of videos you want to learn from on YouTube. Save the links to edit later.
3. 🚀 Try watching the videos at a faster speed while exercising, and sample the first five minutes of each video.
4. 📜 Reorder the playlist so the most useful videos are at the front, and take breaks to exercise.
5. 📝 Practice note-taking in markdown to instantly save what you want to remember. Share your notes with others!
6. 👥 AI Pair Programming Using Long Answer Language Models with Human Feedback:
## 🎥 2023 AI/ML Advanced Learning Playlists:
1. [2023 QA Models and Long Form Question Answering NLP](https://www.youtube.com/playlist?list=PLHgX2IExbFovrkkx8HMTLNgYdjCMNYmX_)
2. [FHIR Bioinformatics Development Using AI/ML and Python, Streamlit, and Gradio - 2022](https://www.youtube.com/playlist?list=PLHgX2IExbFovoMUC3hYXeFegpk_Y0Lz0Q)
3. [2023 ChatGPT for Coding Assistant Streamlit, Gradio and Python Apps](https://www.youtube.com/playlist?list=PLHgX2IExbFouOEnppexiKZVdz_k5b0pvI)
4. [2023 BigScience Bloom - Large Language Model for AI Systems and NLP](https://www.youtube.com/playlist?list=PLHgX2IExbFouqnsIqziThlPCX_miiDq14)
5. [2023 Streamlit Pro Tips for AI UI UX for Data Science, Engineering, and Mathematics](https://www.youtube.com/playlist?list=PLHgX2IExbFou3cP19hHO9Xb-cN8uwr5RM)
6. [2023 Fun, New and Interesting AI, Videos, and AI/ML Techniques](https://www.youtube.com/playlist?list=PLHgX2IExbFotoMt32SrT3Xynt5BXTGnEP)
7. [2023 Best Minds in AGI AI Gamification and Large Language Models](https://www.youtube.com/playlist?list=PLHgX2IExbFotmFeBTpyje1uI22n0GAkXT)
8. [2023 State of the Art for Vision Image Classification, Text Classification and Regression, Extractive Question Answering and Tabular Classification](https://www.youtube.com/playlist?list=PLHgX2IExbFotPcPu6pauNHOoZTTbnAQ2F)
9. [2023 AutoML DataRobot and AI Platforms for Building Models, Features, Test, and Transparency](https://www.youtube.com/playlist?list=PLHgX2IExbFovsY2oGbDwdEhPrakkC8i3g)
""")


st.markdown("""
# Cognitive AI with Human Feedback (CAHF) [Example 🩺⚕️](https://huggingface.co/spaces/awacke1/Cognitive-AI-Episodic-Semantic-Memory-Demo):
1. Create and use Models to predict __outcomes__
2. Use AI to predict **conditions, disease, and opportunities** using AI with **explainability**.
3. **Cognitive AI** - Mimic how humans reason through decision making processes.
4. **Reasoning cycles** - "Recommended for You" reasoners - consider type of personalized needs and classification for users, to recommend products
5. **High Acuity Reasoners** - Make decisions on rules of **what it can and cannot do within human feedback** guidelines.
    -Emphasizes **explainability, transparency, and removing administrative burden** to **protocolize** and improve what staff is doing.
    -Vetted by SME's, adding value of **judgement and training** and pick up intelligence and **skills from human feedback**.
    -**Alert, Recommended Action, and Clinical Terms** per entity with vocabularies from LOINC, SNOMED, OMS, ICD10, RXNORM, SMILES, HCPCS, CPT, CQM, HL7, SDC and FHIR.
6. Non static multi agent cognitive approach using real time series to identify factors predictive of outcome.
7. Cognitive models form of Ontology - to create a type of computable sets and relationships stored in Ontology then ingested by reasoner
    -Use models of world to build predictions and recommendations with answers cumulative with information we know
8. Reasoners standardize making it easy as possible to do right thing using transfer learning and recommendation tools with questions and actions.
""")


st.markdown("""
# 📚 Clinical Terminology and Ontologies [Example 🩺⚕️NLP Clinical Ontology Biomedical NER](https://huggingface.co/spaces/awacke1/Biomed-NLP-AI-Clinical-Terminology)
## Health Vocabularies, Systems of Coding, and Databases with Bibliographies
##__Keywords__:
1. __Clinical Terminology__: 💬 Words that doctors use to talk to each other about patients.
2. __Ontologies for Medications and Conditions__: 📚 A fancy way of organizing knowledge about medicine and health problems.
3. __Health Vocabularies__: 📝 A special list of words used in healthcare to talk about health issues.
4. __Systems of Coding__: 💻 A way of giving things like sicknesses and treatments special codes, so that doctors can remember them easily.
5. __Databases__: 🗄️ A computer system that stores information about patients, health research, and other healthcare things.
6. __Bibliographies__: 📖 A list of books or articles that doctors use to learn about new health information.
1. ## 1️⃣ National Library of Medicine's **RxNorm**:
    - Standardized nomenclature for clinical drugs developed by NLM
    - Provides links between drug names and related information such as ingredients, strengths, and dosages
    - **Data type: controlled vocabulary**
    - Access through **NLM's RxNorm website**: https://www.nlm.nih.gov/research/umls/rxnorm/index.html
2. ## 2️⃣ Centers for Medicare and Medicaid Services' Healthcare Common Procedure Coding System (HCPCS):
    - Coding system used to identify healthcare **services, procedures, and supplies**
    - Includes **codes for drugs, biologicals, and other items** used in medical care
    - **Data type: coding system**
    - Access through **CMS website**: https://www.cms.gov/Medicare/Coding/MedHCPCSGenInfo
3. ## 3️⃣ Unified Medical Language System (UMLS):
    - Set of files and software tools developed by NLM for integrating and mapping biomedical vocabularies
    - Includes RxNorm and other drug vocabularies, as well as other terminologies used in medicine
    - **Data type: controlled vocabulary**
    - Access through UMLS Metathesaurus: https://www.nlm.nih.gov/research/umls/index.html
4. ## 4️⃣ PubMed:
    - Database of **biomedical literature** maintained by the National Center for Biotechnology Information (NCBI)
    - Includes information about **drugs, including drug names, chemical structures, and pharmacological actions**
    - **Data type: bibliographic database**
    - Access through **PubMed website**: https://pubmed.ncbi.nlm.nih.gov/
5. ## 5️⃣ PubChem:
    - Database of chemical substances maintained by NCBI
    - Includes information about drugs, including **chemical structures, properties, and activities**
    - **Data type: chemical database**
    - Access through **PubChem website**: https://pubchem.ncbi.nlm.nih.gov/
6. ## 6️⃣ Behavioral Health Code Terminology Sets:
    - Code terminology sets specific to behavioral health
    - Includes **DSM** published by American Psychiatric Association, **ICD** published by World Health Organization, and **CPT** published by American Medical Association
    - **Data type: coding system**
    - Access through respective **organizations' websites**:
        1. [DSM](https://www.psychiatry.org/psychiatrists/practice/dsm)
        2. [ICD](https://www.who.int/standards/classifications/classification-of-diseases)
        3. [CPT](https://www.ama-assn.org/practice-management/cpt/current-procedural-terminology-cpt)
""")

st.markdown("""
1. # 📚Natural Language Processing🔤 - 🗣️🤖💭💬🌍🔍
    1. 🤔 **🩺⚕️ Sentiment analysis** - Determine underlying sentiment of text.  [Example](https://huggingface.co/spaces/awacke1/Sentiment-analysis-streamlit)
    2. 📝 **Named Entity Recognition (NER)** - Identify and classify named entities in text.  [Example](https://huggingface.co/spaces/awacke1/Named-entity-resolution)
    3. 🔊 **🩺⚕️Automatic Speech Recognition (ASR)** - Transcribe spoken language into text.
    # Advanced NLP ASR Examples:
        1. 🩺⚕️ https://huggingface.co/spaces/awacke1/ASR-High-Accuracy-Test
        2. https://huggingface.co/spaces/awacke1/ASRGenerateStory
        3. 🩺⚕️ https://huggingface.co/spaces/awacke1/TTS-STT-Blocks
        4. 🩺⚕️ https://huggingface.co/spaces/awacke1/CloneAnyVoice
        5. https://huggingface.co/spaces/awacke1/ASR-SOTA-NvidiaSTTMozilla
    4. 🌐 **Machine translation** - Translate text between languages automatically.  [Example](https://huggingface.co/spaces/awacke1/Machine-translation)
    5. 📄 **Text summarization** - Automatically summarize large volumes of text.  [Example](https://huggingface.co/spaces/awacke1/Text-summarization)
    6. ❓ **🩺⚕️ Question answering** - Answer questions posed in natural language.  [Example](https://huggingface.co/spaces/awacke1/Question-answering)
    7. 🤖 **Sentiment-aware chatbots** - Use sentiment analysis to detect user emotions and respond appropriately.
    8. 📊 **🩺⚕️ Text classification** - Classify text into different categories.  [Example](https://huggingface.co/spaces/awacke1/sileod-deberta-v3-base-tasksource-nli)
    9. 💬 **🩺⚕️ Text generation** - Generate natural language text.  [Example](https://huggingface.co/spaces/awacke1/Sentence2Paragraph)
    10. 🔎 **Topic modeling** - Automatically identify topics in a large corpus of text.  [Example](https://huggingface.co/spaces/awacke1/Topic-modeling)
    - Examples
        1. [NLP Video Summary](https://huggingface.co/spaces/awacke1/Video-Summary)
        2. [TTS-STT ASR with Multiple Voices](https://huggingface.co/spaces/awacke1/TTS-STT-Blocks)
        3. [NLP Transcript with Video Player](https://huggingface.co/spaces/awacke1/Streamlit-ASR-Video)
        4. [NLP Clinical Ontology Biomedical NER](https://huggingface.co/spaces/awacke1/Biomed-NLP-AI-Clinical-Terminology)
        5. [Document Understanding and NLP](https://huggingface.co/spaces/awacke1/AIDocumentUnderstandingOCR)
        6. [NLP ASR Wav2Vec2 Multilingual](https://huggingface.co/spaces/awacke1/ASR-High-Accuracy-Test)
        7. [Live ASR](https://huggingface.co/spaces/awacke1/ASR-SOTA-NvidiaSTTMozilla)
        8. [NLP and Visualization](https://huggingface.co/spaces/awacke1/Visualization-Plotly-Sunbursts-Treemaps-and-WebGL)
""")

st.markdown("""
2. # 🔮Generative AI💭 (🎨Images and 📝Text)  -  🎵🧩🔄📊🌌
    1. 🆕 **🩺⚕️ Generation of new data**: Create new data that resembles existing data. [Example](https://huggingface.co/spaces/awacke1/GenAI-Generate-New-Data-Resembling-Example)
    2. 🎨 **Creative potential**: Generate music, art, or literature. [Example](https://huggingface.co/spaces/awacke1/Creative-Potential-Music-Art-Lit)
    3. 📊 **Data synthesis**: Synthesize data from multiple sources to create new datasets.  [Example](https://huggingface.co/spaces/awacke1/Data-Synthesizer-Synthesize-From-Multiple-Sources)
    4. 📈 **🩺⚕️ Data augmentation**: Augment existing datasets to make them larger and more diverse.  [Example](https://huggingface.co/spaces/awacke1/Data-Augmentation)
    5. 🔀 **Domain transfer**: Transfer knowledge learned from one domain to another.
    6. 🔍 **Unsupervised learning**: Learn patterns without labeled training data.
    7. 🔄 **Adaptive learning**: Adapt to changes in data over time.
    8. 🔊 **Noise injection**: Introduce noise to explore a wider range of possibilities.
    9. 🕶️ **Latent space manipulation**: Control output by manipulating a model's latent space.
    10. 🖼️ **Realistic output**: Produce output that is difficult to distinguish from human-created data.
    - Examples
        1. Quantum AI Circuits: https://huggingface.co/spaces/awacke1/AI-Quantum?option=Circuit
        2. Generate Story and Video: https://huggingface.co/spaces/awacke1/ASRGenerateStoryandVideo
        3. ASR Generate Story: https://huggingface.co/spaces/awacke1/ASRGenerateStory
        4. Music Generation: https://huggingface.co/spaces/awacke1/MusicMaker
""")

st.markdown("""
3. # 📷Image Recognition🏞️ 
    1. 📷 **Object detection**: Detect and identify multiple objects in an image for detailed analysis and classification.
    2. 🏞️ **Scene recognition**: Recognize and classify entire scenes based on objects, colors, and shapes.
    3. 😃 **Facial recognition**: Analyze facial features for accurate identification.
    4. 😊 **Emotion recognition**: Identify emotions on a subject's face, including happiness, sadness, and anger.
    5. 🔤 **Text recognition**: Identify and translate text in images for analysis.
    6. 🎨 **Color recognition**: Detect colors and provide information on hue, saturation, and brightness.
    7. 🔍 **Image segmentation**: Divide an image into multiple regions for individual analysis and classification.
    8. 🌅 **Image restoration**: Remove noise and blur, restoring images to original clarity and quality.
    9. 🔖 **Image classification**: Classify images into categories like animals, buildings, or landscapes.
    10. 🎨 **Style transfer**: Apply the style of one image to another for unique and innovative results.
    - Examples
        1. 🩺⚕️ Text-to-Image : [Image Classification](https://huggingface.co/spaces/awacke1/Prompt-Refinery-Text-to-Image-Generation)
        2. Image Captions from 5 SOTA Generators: [URL](https://huggingface.co/spaces/awacke1/ImageCaptionPromptGenerator)
        3. 🩺⚕️ Image to Multilingual OCR: [URL](https://huggingface.co/spaces/awacke1/Image-to-Multilingual-OCR)
        4. WRN - Wide Residual Networks: [URL](https://huggingface.co/spaces/awacke1/ResnetPytorchImageRecognition)
        5. AI Document Understanding: [URL](https://huggingface.co/spaces/awacke1/AIDocumentUnderstandingOCR)
        6. Elixir Docker Bumblebee: [URL](https://huggingface.co/spaces/awacke1/DockerImageRecognitionToText)
        7. Speech to Text to Story to Images to Video: [URL](https://huggingface.co/spaces/awacke1/Speeech2Text2Story2Images2Video)
        8. Image to Line Drawings: [URL](https://huggingface.co/spaces/awacke1/Image-to-Line-Drawings)
        9. Semantic Image Search: [URL](https://huggingface.co/spaces/awacke1/Image-Semantic-Search)
        10. Zoom Clip Toon: [URL](https://huggingface.co/spaces/awacke1/Zoom-Clip-Toon-Image-to-Image)
        11. Image to Reading Labels: [URL](https://huggingface.co/spaces/awacke1/ImageOCRMultilingual)
        12. A Game For That - Gamification Using Snapshot Images: [URL](https://huggingface.co/spaces/awacke1/AGameForThat)
        13. AI Visually Plays QBert, Pong, Seaquest and more: [URL](https://huggingface.co/spaces/awacke1/AI-Atari-Live-Streamlit)
        14. AI Creates Generator Style Mix Art from Encyclopedia: [URL](https://huggingface.co/spaces/awacke1/Art-Generator-and-Style-Mixer)
        15. BigGAN Image Gen and Search: [URL](https://huggingface.co/spaces/awacke1/AI-BigGAN-Image-Gen)
        16. Art Style Line Drawings: [URL](https://huggingface.co/spaces/awacke1/ArtStyleFoodsandNutrition)
        17. 🩺⚕️ Yolo Real Time Image Recognition from Webcam: https://huggingface.co/spaces/awacke1/Webcam-Object-Recognition-Yolo-n-Coco
""")

st.markdown("""
4. # 🗣️Speech Recognition💬
    1. 🔊 **Continuous Speech Recognition**: Transcribe spoken words in real-time without pausing.
    2. 🗣️ **Speaker Identification**: Identify individual speakers through unique features in their speech.
    3. 🧠 **Contextual Awareness**: Understand conversation context and interpret word meaning.
    4. 🌎 **Multilingual Support**: Recognize and transcribe multiple languages for translation.
    5. 🔇 **Noise Reduction**: Filter out background noise to improve transcription quality.
    6. 🔒 **Voice Biometrics**: Verify speaker identity and provide secure access to personal data.
    7. 🎛️ **Command and Control**: Interpret voice commands to automate tasks and interact with software.
    8. 💬 **Natural Language Processing**: Understand complex human speech patterns.
    9. 🧠 **Adaptive Learning**: Learn and adapt to improve accuracy over time.
    10. ☁️ **Cloud-Based Deployment**: Real-time processing of large amounts of data, even on mobile devices.
""")

st.markdown("""
5. # Reinforcement Learning
    1. 🏆 **Reward-driven**: RL uses rewards or punishments to drive its learning process.
    2. 🧪 **Trial-and-error learning**: RL is a trial-and-error learning method, where an agent tries different actions to find the best action that will maximize the cumulative reward.
    3. 🤔 **Exploration-exploitation trade-off**: RL agents need to balance exploration and exploitation to find new possibilities while also exploiting successful actions.
    4. 📈 **Markov Decision Processes**: RL uses MDPs to model decision-making processes.
    5. 📊 **Policy optimization**: RL uses policy optimization techniques to find the best policy for a given task or learn the optimal policy from scratch.
    6. 💰 **Value-based methods**: RL uses value-based methods to estimate the value of each state or action.
    7. 🧠 **Model-based methods**: RL can use model-based methods to predict the outcomes of different actions.
    8. 🤖 **Deep Reinforcement Learning**: DRL combines RL with deep learning techniques to learn complex decision-making tasks.
    9. 🔄 **Transfer learning**: RL can use transfer learning techniques to transfer knowledge learned in one task to another task.
    10. 🤝 **Multi-agent RL**: RL can handle multiple agents that interact with each other.
""")

st.markdown("""
6. 🎲Game Theory🎲 – Traditional AI processes
    1. 🤝 **Interdependence**: Game Theory considers decision-making among multiple agents, unlike traditional AI processes which focus on a single agent.
    2. 🎯 **Strategic Behavior**: Game Theory assumes that agents aim to maximize their payoffs based on the actions of other agents. Traditional AI may not consider this strategic element.
    3. 💰 **Payoffs**: Game Theory calculates payoffs for each agent based on their actions and the actions of other agents, unlike traditional AI which may focus on a single objective.
    4. ⚖️ **Equilibrium**: Game Theory seeks to identify stable states in the game where no agent has an incentive to deviate from their current strategy. Traditional AI may not seek to find an equilibrium.
    5. 🎲 **Game Formulation**: Game Theory formulates a game, including rules, players, and possible actions, unlike traditional AI which may not require such formulation.
    6. 💡 **Solution Concepts**: Game Theory has various solution concepts, such as Nash Equilibrium and Pareto Efficiency, to identify the most desirable outcomes. Traditional AI may not have such concepts.
    7. 📊 **Information**: Game Theory considers the information available to each agent in the game. Traditional AI may not consider information explicitly.
    8. ⚔️ **Adversarial**: Game Theory models adversarial scenarios where agents have conflicting goals. Traditional AI may assume cooperation among agents.
    9. ❓ **Uncertainty**: Game Theory deals with uncertainty and incomplete information in the game. Traditional AI may not consider uncertainty.
    10. 🌐 **Complexity**: Game Theory deals with complex multi-agent interactions. Traditional AI may focus on single-agent optimization.
    - Examples
        1. 🩺⚕️ Health Care Game: https://huggingface.co/spaces/awacke1/AI-RPG-Self-Play-RLML-Health-Battler-Game
        2. 🩺⚕️ Sankey Snacks Math Chart Animator:  https://huggingface.co/spaces/awacke1/Sankey-Snacks
        3. Blackjack 21 : https://huggingface.co/spaces/awacke1/BlackjackSimulatorCardGameAI
        4. Player Card Monster Battler: https://huggingface.co/spaces/awacke1/Player-Card-Monster-Battler-For-Math-and-AI
        5. Emojitrition: https://huggingface.co/spaces/awacke1/Emojitrition-Fun-and-Easy-Nutrition
""")

st.markdown("""
7. # 🃏Card Game🃏 Activity
    1. 🃏 **Card crafting**: Combine existing cards or materials to craft custom cards. [Example](https://huggingface.co/spaces/awacke1/CardCrafter-CraftCustomCards)
    2. 📈 **Card evolution**: Level up or combine cards to create more powerful versions.
    3. 🔨 **Deck building**: Build custom decks that match your play style.
    4. ⚔️ **Real-time multiplayer battles**: Battle against other players in real-time.
    5. 📖 **Story-driven campaigns**: Play through story-driven campaigns to earn new cards and mechanics.
    6. 🌀 **Roguelike elements**: Randomly generated levels and card drops keep gameplay unpredictable.
    7. 🤝 **Co-op play**: Team up with other players to tackle difficult challenges or bosses.
    8. 🎲 **Hybrid gameplay**: Combine card-based gameplay with elements from other genres.
    9. 💥 **Multi-card play**: Use multiple cards at once to create powerful combos or synergies.
    10. 🗺️ **Tactical positioning**: Strategically place your cards on a game board or battlefield to gain an advantage.
    - Examples
        1. 🩺⚕️ Game Activity Graph: https://huggingface.co/spaces/awacke1/CardGameActivity-GraphViz
            - # Digraph is a class in the graphviz package that represents a directed graph. 
            1. It is used to create graphs with nodes and edges.
            2. It can be customized with various styles and formatting options. 
            3. This is an example of defining a Digraph with emojis for the node labels:
        2. 🩺⚕️ SVG Card Generation: https://huggingface.co/spaces/awacke1/VizLib-SVGWrite-Streamlit
            - # Scalable Vector Graphics (SVG) is an important language used in UI and graphic design.
        3. Game Mechanics Top 20: https://huggingface.co/spaces/awacke1/CardGameMechanics
        4. Game Mechanics Deep Dive: https://huggingface.co/spaces/awacke1/CardGameActivity
        5. Hexagon Dice: https://huggingface.co/spaces/awacke1/Hexagon-Dice-Fractal-Math-Game
        6. Dice Roll Game: https://huggingface.co/spaces/awacke1/Dice-Roll-Fractals-STEM-Math
        7. Pyplot Dice Game: https://huggingface.co/spaces/awacke1/Streamlit-Pyplot-Math-Dice-Game 
""")


st.markdown("""
## AI For Long Question Answering and Fact Checking [Example](🩺⚕️ https://huggingface.co/spaces/awacke1/StreamlitWikipediaChat)
1. 🖥️ First, we'll teach a smart computer to browse the internet and find information. 
    - 🧠 It will be like having a super-smart search engine!
2. 🤖 Then, we'll train the computer to answer questions by having it learn from how humans answer questions.
    - 🤝 We'll teach it to imitate how people find and use information on the internet.
3. 📚 To make sure the computer's answers are correct, we'll teach it to collect references from the internet to support its answers.
    - 🔍 This way, it will only give answers that are true and based on facts.
4. 👨‍👩‍👧‍👦 We'll test our invention on a special set of questions that real people have asked.
    - 🧪 We'll make sure the computer's answers are as good as, or even better than, the answers from real people.
5. 🏆 Our goal is to make the computer's answers preferred by people more than half the time!
    - 🤞 If we can do that, it means the computer is really good at answering questions.
""")



st.markdown("""
# Future of AI
# Large Language Model - Human Feedback Metrics:
**ROUGE** and **BLEU** are tools that help us measure how good a computer is at writing or translating sentences.
## 🩺⚕️ [ROUGE](https://huggingface.co/spaces/evaluate-metric/rouge)
## 🩺⚕️ [BLEU](https://huggingface.co/spaces/evaluate-metric/bleu)
1. ROUGE looks at a sentence made by a computer and checks how similar it is to sentences made by humans. 
    1. It tries to see if the important information is the same.
2. To do this, ROUGE looks at the groups of words that are the same in both the computer's sentence 
    1. and the human's sentence. 
    2. The more groups of words that are the same, the higher the score.
3. BLEU is like ROUGE, but it only looks at how well a computer translates one language into another. 
    1. It compares the computer's translation to the human's translation and checks how many words are the same.
# If the scores for ROUGE or BLEU are high, it means that the computer is doing a good job. 
1. But it's also important to remember that these tools have their limits, 
2. and we need to use other ways to check if the computer is doing a good job.
1. **ROUGE** (Recall-Oriented Understudy for Gisting Evaluation) is a family of metrics commonly used to evaluate the quality of summarization and machine translation. ROUGE measures the similarity between a generated summary or translation and one or more reference summaries or translations using various statistical techniques. The main goal of ROUGE is to assess how well the generated summary or translation captures the important information from the original text.
2. **ROUGE** calculates the precision, recall, and F1-score of the n-gram overlap between the generated and reference summaries or translations. Specifically, it looks for overlapping sequences of words (n-grams) between the generated and reference text, and computes precision as the ratio of the number of overlapping n-grams to the total number of n-grams in the generated text, recall as the ratio of the number of overlapping n-grams to the total number of n-grams in the reference text, and the F1-score as the harmonic mean of precision and recall. ROUGE can be computed at different n-gram levels, including unigrams, bigrams, trigrams, etc., as well as at the sentence or document level.
3. **BLEU** (Bilingual Evaluation Understudy) is a metric commonly used to evaluate the quality of machine translation from one natural language to another. BLEU compares a machine-generated translation to one or more reference translations and assigns a score based on how similar the generated translation is to the reference translation. BLEU uses a modified form of precision to calculate the score.
4. **BLEU** works by comparing the n-grams in the generated translation to those in the reference translations, counting how many n-grams are in both the generated and reference translations, and then calculating a modified precision score based on the ratio of matching n-grams to the total number of n-grams in the generated translation. BLEU can be computed at different n-gram levels, including unigrams, bigrams, trigrams, etc. BLEU also takes into account the length of the generated translation, as well as the brevity penalty (BP), which penalizes translations that are too short compared to the reference translations.
5. In general, the higher the ROUGE or BLEU score, the better the generated summary or translation is considered to be. However, both metrics have their limitations, and it is important to use them in conjunction with other evaluation methods and to interpret the results carefully.
""")


st.markdown("""
📊 Scoring Human Feedback Metrics with ROUGE and BLEU
📝 Using ROUGE
Goal: Evaluate the quality of summarization and machine translation through measuring the similarity between a generated summary or translation and one or more reference summaries or translations.
Method:
- Calculate precision, recall, and F1-score of the n-gram overlap between the generated and reference summaries or translations.
- Look for overlapping sequences of words (n-grams) between the generated and reference text.
- Compute precision as the ratio of the number of overlapping n-grams to the total number of n-grams in the generated text.
- Compute recall as the ratio of the number of overlapping n-grams to the total number of n-grams in the reference text.
- Compute the F1-score as the harmonic mean of precision and recall.
- ROUGE can be computed at different n-gram levels, including unigrams, bigrams, trigrams, etc., as well as at the sentence or document level.
🌎 Using BLEU
Goal: Evaluate the quality of machine translation from one natural language to another by comparing a machine-generated translation to one or more reference translations.
Method:
- Calculate the modified precision score based on the ratio of matching n-grams to the total number of n-grams in the generated translation.
- Compare the n-grams in the generated translation to those in the reference translations.
- Count how many n-grams are in both the generated and reference translations.
- BLEU can be computed at different n-gram levels, including unigrams, bigrams, trigrams, etc.
- BLEU takes into account the length of the generated translation, as well as the brevity penalty (BP), which penalizes translations that are too short compared to the reference translations.
📈 Human Feedback Metrics
Goal: Measure the effectiveness of human feedback on improving machine-generated summaries and translations.
Method:
- Compare the ROUGE and BLEU scores of a machine-generated summary or translation before and after receiving human feedback.
Example:
1. Generate a summary or translation using a machine translation system.
2. Calculate the ROUGE and BLEU scores for the machine-generated output.
3. Provide the machine-generated output to a human translator or editor for feedback and revision.
4. Re-calculate the ROUGE and BLEU scores for the revised output.
5. Compare the scores to measure the effectiveness of the human feedback.
""")



st.markdown("""
# 🩺⚕️ Reinforcement Learning from Human Feedback (RLHF) 
## 🤖 RLHF is a way for computers to learn how to do things better by getting help and feedback from people, 
    - just like how you learn new things from your parents or teachers.
🎮 Let's say the computer wants to learn how to play a video game. 
    - It might start by trying different things and seeing what happens.
👍 If it does something good, like getting a high score, it gets a reward.
👎 If it does something bad, like losing a life, it gets a punishment.
👩‍💻 Now, imagine that a person is watching the computer play the game and giving it feedback. 
    -The person might say things like "Good job!" when the computer gets a high score 
    - or "Oops, try again!" when it loses a life.
💡 This feedback helps the computer figure out which actions are good and which ones are bad. 
    -The computer then uses this feedback to adjust its actions and get better at playing the game.
🤔 It might try different strategies and see which ones get the best feedback from the person. 
    -Over time, the computer gets better and better at playing the game, just like how you get better at things by practicing and getting help from others.
🚀 RLHF is a cool way for computers to learn and improve with the help of people. 
    -Who knows, maybe one day you can teach a computer to do something amazing!
# Examples
## 🩺⚕️ Hospital Visualizations
🩺⚕️ https://huggingface.co/spaces/awacke1/VizLib-TopLargeHospitalsMinnesota
🩺⚕️ https://huggingface.co/spaces/awacke1/VizLib-TopLargeHospitalsNewJersey
🩺⚕️ https://huggingface.co/spaces/awacke1/VizLib-TopLargeHospitalsMentalHealth
🩺⚕️ https://huggingface.co/spaces/awacke1/VizLib-GraphViz-Folium-MapTopLargeHospitalsinWI
# Card Game Activity
https://huggingface.co/spaces/awacke1/CardGameActivity-GraphViz
https://huggingface.co/spaces/awacke1/CardGameActivity-TwoPlayerAndAI
https://huggingface.co/spaces/awacke1/CardGameActivity
https://huggingface.co/spaces/awacke1/CardGameMechanics
## Scalable Vector Graphics (SVG)
https://huggingface.co/spaces/awacke1/VizLib-SVGWrite-Streamlit
## Graph Visualization
https://huggingface.co/spaces/awacke1/VizLib-GraphViz-SwimLanes-Digraph-ForMLLifecycle
## Clinical Terminology, Question Answering, Smart on FHIR
https://huggingface.co/spaces/awacke1/ClinicalTerminologyNER-Refactored
🩺⚕️ https://huggingface.co/spaces/awacke1/Assessment-By-Organs
🩺⚕️ https://huggingface.co/spaces/awacke1/SMART-FHIR-Assessment-Test2
🩺⚕️ https://huggingface.co/spaces/awacke1/FHIRLib-FHIRKit
""")

st.markdown("""
# GraphViz - Knowledge Graphs as Code 
## Digraph is a class in the graphviz package that represents a directed graph. 
1. It is used to create graphs with nodes and edges.
2. It can be customized with various styles and formatting options. 
""")

# Graph showing two player game theory:

card_game_dot = Digraph()
card_game_dot.node('start', shape='diamond', label='Start')
card_game_dot.node('end', shape='diamond', label='End')
card_game_dot.node('player1', shape='box', label='Player 1')
card_game_dot.node('player2', shape='box', label='Player 2')
card_game_dot.node('action', shape='parallelogram', label='Action')
card_game_dot.edge('start', 'player1')
card_game_dot.edge('player1', 'action', label='Action 1')
card_game_dot.edge('action', 'player2', label='Action 2')
card_game_dot.edge('player2', 'end')
st.graphviz_chart(card_game_dot)

# Game Theory - Traditional AI processes

game_theory_dot = Digraph()
game_theory_dot.node('player1', shape='box', label='Player 1')
game_theory_dot.node('player2', shape='box', label='Player 2')
game_theory_dot.node('decision', shape='parallelogram', label='Decision')
game_theory_dot.node('outcome', shape='ellipse', label='Outcome')
game_theory_dot.edge('player1', 'decision', label='Decision 1')
game_theory_dot.edge('player2', 'decision', label='Decision 2')
game_theory_dot.edge('decision', 'outcome')
st.graphviz_chart(game_theory_dot)

# Examples of AI

examples_dot = Digraph()
examples_dot.node('start', shape='diamond', label='Start')
examples_dot.node('end', shape='diamond', label='End')
examples_dot.node('agi', shape='box', label='AGI')
examples_dot.node('students', shape='box', label='Students 🎓')
examples_dot.node('scientists', shape='box', label='Scientists 🔬')
examples_dot.node('business', shape='box', label='Business Leaders 💼')
examples_dot.node('medical', shape='box', label='Medical Professionals 🩺')
examples_dot.node('engineers', shape='box', label='Engineers 🛠️')
examples_dot.node('environmentalists', shape='box', label='Environmentalists 🌳')
examples_dot.node('government', shape='box', label='Government Leaders 🏛️')
examples_dot.edge('start', 'agi')
examples_dot.edge('agi', 'students')
examples_dot.edge('agi', 'scientists')
examples_dot.edge('agi', 'business')
examples_dot.edge('agi', 'medical')
examples_dot.edge('agi', 'engineers')
examples_dot.edge('agi', 'environmentalists')
examples_dot.edge('agi', 'government')
examples_dot.edge('students', 'end', label='🧑‍🎓📚💡')
examples_dot.edge('scientists', 'end', label='👨‍🔬💻🔭')
examples_dot.edge('business', 'end', label='💰📈💻')
examples_dot.edge('medical', 'end', label='👨‍⚕️💉🌡️')
examples_dot.edge('engineers', 'end', label='👷‍♂️🤖🚀')
examples_dot.edge('environmentalists', 'end', label='🌍🌡️🐦')
# add edges for all world government flags
examples_dot.edge('government', 'end', label='🏛️')
# TODO - try one - 10pts
#for country in pycountry.countries:
#    flag_url = f'https://www.countryflags.io/{country.alpha_2}/flat/64.png'
#    examples_dot.node(country.alpha_2, label='', image=flag_url, height='0.7', width='1.0')
#    examples_dot.edge(country.alpha_2, 'government')
st.graphviz_chart(examples_dot)


# Image Recognition
image_recognition_dot = Digraph()
image_recognition_dot.node('start', shape='diamond', label='Start')
image_recognition_dot.node('end', shape='diamond', label='End')
image_recognition_dot.node('input', shape='box', label='Input Image 📷')
image_recognition_dot.node('model', shape='box', label='Model 🧠')
image_recognition_dot.node('output', shape='box', label='Output Label 🔍')
image_recognition_dot.edge('start', 'input')
image_recognition_dot.edge('input', 'model')
image_recognition_dot.edge('model', 'output')
image_recognition_dot.edge('output', 'end')
st.graphviz_chart(image_recognition_dot)

# Speech Recognition
speech_recognition_dot = Digraph()
speech_recognition_dot.node('start', shape='diamond', label='Start')
speech_recognition_dot.node('end', shape='diamond', label='End')
speech_recognition_dot.node('input', shape='box', label='Input Audio 🎤')
speech_recognition_dot.node('model', shape='box', label='Model 🧠')
speech_recognition_dot.node('output', shape='box', label='Output Text 📝')
speech_recognition_dot.edge('start', 'input')
speech_recognition_dot.edge('input', 'model')
speech_recognition_dot.edge('model', 'output')
speech_recognition_dot.edge('output', 'end')
st.graphviz_chart(speech_recognition_dot)

# Generative AI (images and text)
generative_ai_dot = Digraph()
generative_ai_dot.node('start', shape='diamond', label='Start')
generative_ai_dot.node('end', shape='diamond', label='End')
generative_ai_dot.node('input', shape='box', label='Input 🧐')
generative_ai_dot.node('model', shape='box', label='Model 🧠')
generative_ai_dot.node('output', shape='box', label='Output 🎨✍️')
generative_ai_dot.edge('start', 'input')
generative_ai_dot.edge('input', 'model')
generative_ai_dot.edge('model', 'output')
generative_ai_dot.edge('output', 'end')
st.graphviz_chart(generative_ai_dot)

# Future of AI
future_ai_dot = Digraph()
future_ai_dot.node('start', shape='diamond', label='Start')
future_ai_dot.node('end', shape='diamond', label='End')
future_ai_dot.node('ai', shape='box', label='AI 🤖🚀🧠')
future_ai_dot.node('question', shape='diamond', label='Question ❓')
future_ai_dot.node('answer', shape='box', label='Answer 💡')
future_ai_dot.edge('start', 'ai')
future_ai_dot.edge('ai', 'question')
future_ai_dot.edge('question', 'answer')
future_ai_dot.edge('answer', 'end')
st.graphviz_chart(future_ai_dot)

# Future of Super Intelligence
super_intelligence_dot = Digraph()
super_intelligence_dot.node('start', shape='diamond', label='Start')
super_intelligence_dot.node('end', shape='diamond', label='End')
super_intelligence_dot.node('agi', shape='box', label='AGI 🤖🚀🧠')
super_intelligence_dot.node('sub1', shape='box', label='Subgraph 1 🌟')
super_intelligence_dot.node('sub2', shape='box', label='Subgraph 2 🌟')
super_intelligence_dot.node('sub3', shape='box', label='Subgraph 3 🌟')
st.graphviz_chart(super_intelligence_dot)



st.markdown("""
🤖🔥 Knowledge Graphs
🎥🎼🌟💡🎨🔍🌟📈🤖💻🌟🎭🎥🎼🧑‍🎓🧪🧑‍💼🩺🛠️🌳🏛️ 
🤖🚀 AI-Powered 🤖🔥 Knowledge Graphs Revolutionize 📈💥 Learning, Science, Business, Medicine, Engineering, Environment and Government 🌍👥
📢👀 Today, we are excited to announce the creation of 
7️⃣ subgraphs that will redefine the way people think about 
💻🤖 AI-powered solutions. Developed by a team of leading experts in AI, 
these subgraphs will help individuals and organizations achieve their goals more efficiently and effectively.
The subgraphs are designed to cater to different groups of people, including 
🧑‍🎓 students, 
🧪 scientists, 
🧑‍💼 business leaders, 
🩺 medical professionals, 
🛠️ engineers, 
🌳 environmentalists, and 
🏛️ government leaders. 
Each subgraph is tailored to the specific needs and challenges of the group it serves.
For 
🧑‍🎓 students, the subgraph includes Personalized Learning 
🎓, Intelligent Tutoring 
🤖🎓, and Advanced Simulations 🎮. 
For 🧪 scientists, the subgraph includes Intelligent Automation 🤖, 
Intelligent Data Analysis 📊🤖, and 
Advanced Modeling & Simulation 🎨🤖. 
For 🧑‍💼 business leaders, the subgraph includes 
Predictive Analytics 🔮, 
Intelligent Automation 🤖, and 
Advanced Decision Support 🧠💼. 
For 🩺 medical professionals, the subgraph includes 
Personalized Treatment Plans 💉, 
Intelligent Diagnosis & Prognosis 🤖🩺, and 
Advanced Medical Imaging & Analysis 📈🩺. 
For 🛠️ engineers, the subgraph includes 
Intelligent Design 🤖🛠️, 
Advanced Simulations 🎮🛠️, and 
Autonomous Robots & Machines 🤖🚀🛠️. 
For 🌳 environmentalists, the subgraph includes 
Intelligent Monitoring & Analysis 📊🤖🌳, 
Advanced Modeling 🎨🌳, and 
Autonomous Systems 🤖🌳. 
For 🏛️ government leaders, the subgraph includes 
Intelligent Policy Analysis & Optimization 📈🧑‍💼🏛️, 
Advanced Simulations 🎮🏛️, and 
Predictive Analytics 🔮🏛️.
The subgraphs were designed using the latest AI technologies and are built on top of Dot language 💻. 
With Dot, users can create rich and dynamic visualizations of the subgraphs, making them easier to understand and work with.
"Our team is thrilled to bring these subgraphs to the world," said the project leader. "
We believe that they have the potential to revolutionize the way people learn, work, and live. 
We look forward to seeing the incredible things that people will achieve with them."
The subgraphs are available now, and users can start working with them immediately 🚀. 
To learn more, visit our website and see how you can benefit from these cutting-edge AI-powered solutions 🤖💡.
    
""")


# Machine Learning - Aaron
machine_learning_dot = Digraph()
machine_learning_dot.node('start', shape='diamond', label='Start')
machine_learning_dot.node('end', shape='diamond', label='End')
machine_learning_dot.node('input', shape='box', label='Input Data 💻📊')
machine_learning_dot.node('model', shape='box', label='Model 🧠')
machine_learning_dot.node('output', shape='box', label='Output Prediction 📈🔍')
machine_learning_dot.edge('start', 'input')
machine_learning_dot.edge('input', 'model')
machine_learning_dot.edge('model', 'output')
machine_learning_dot.edge('output', 'end')
st.graphviz_chart(machine_learning_dot)

# Natural Language Processing - Aaron
nlp_dot = Digraph()
nlp_dot.node('start', shape='diamond', label='Start')
nlp_dot.node('end', shape='diamond', label='End')
nlp_dot.node('input', shape='box', label='Input Text 📝')
nlp_dot.node('preprocessing', shape='box', label='Preprocessing 🧹')
nlp_dot.node('model', shape='box', label='Model 🧠')
nlp_dot.node('output', shape='box', label='Output Text 📝')
nlp_dot.edge('start', 'input')
nlp_dot.edge('input', 'preprocessing')
nlp_dot.edge('preprocessing', 'model')
nlp_dot.edge('model', 'output')
nlp_dot.edge('output', 'end')
st.graphviz_chart(nlp_dot)

# Reinforcement Learning - Aaron
rl_dot = Digraph()
rl_dot.node('start', shape='diamond', label='Start')
rl_dot.node('end', shape='diamond', label='End')
rl_dot.node('state', shape='box', label='State 🕹️')
rl_dot.node('action', shape='box', label='Action 🎮')
rl_dot.node('reward', shape='box', label='Reward 🏆')
rl_dot.node('qtable', shape='box', label='Q-Table 🧠')
rl_dot.node('policy', shape='box', label='Policy 🔍')
rl_dot.edge('start', 'state')
rl_dot.edge('state', 'action')
rl_dot.edge('action', 'reward')
rl_dot.edge('reward', 'qtable')
rl_dot.edge('qtable', 'policy')
rl_dot.edge('policy', 'state')
rl_dot.edge('policy', 'end')
st.graphviz_chart(rl_dot)

                            

# Create the graph
dot = Digraph()
dot.attr(rankdir="TB") # Top to Bottom or LR Left to Right

# Define the nodes
dot.node('1', 'Students 🎓')
dot.node('2', 'Scientists 🔬')
dot.node('3', 'Business Leaders 💼')
dot.node('4', 'Medical Professionals 🩺')
dot.node('5', 'Engineers 🛠️')
dot.node('6', 'Environmentalists 🌳')
dot.node('7', 'Government Leaders 🏛️')
dot.node('AI', 'Basic AI Examples')
dot.attr('node', shape='box')

# Define the edges
dot.edges([('1', 'AI'), ('2', 'AI'), ('3', 'AI'), ('4', 'AI'), ('5', 'AI'), ('6', 'AI'), ('7', 'AI')])

# Define the subgraphs
with dot.subgraph(name='cluster_1') as c:
    c.node('1_1', 'Personalized Learning')
    c.node('1_2', 'Intelligent Tutoring')
    c.node('1_3', 'Advanced Simulations')
    c.attr(label='For Students 🎓')

with dot.subgraph(name='cluster_2') as c:
    c.node('2_1', 'Intelligent Automation')
    c.node('2_2', 'Intelligent Data Analysis')
    c.node('2_3', 'Advanced Modeling & Simulation')
    c.attr(label='For Scientists 🔬')

with dot.subgraph(name='cluster_3') as c:
    c.node('3_1', 'Predictive Analytics')
    c.node('3_2', 'Intelligent Automation')
    c.node('3_3', 'Advanced Decision Support')
    c.attr(label='For Business Leaders 💼')

with dot.subgraph(name='cluster_4') as c:
    c.node('4_1', 'Personalized Treatment Plans')
    c.node('4_2', 'Intelligent Diagnosis & Prognosis')
    c.node('4_3', 'Advanced Medical Imaging & Analysis')
    c.attr(label='For Medical Professionals 🩺')

with dot.subgraph(name='cluster_5') as c:
    c.node('5_1', 'Intelligent Design')
    c.node('5_2', 'Advanced Simulations')
    c.node('5_3', 'Autonomous Robots & Machines')
    c.attr(label='For Engineers 🛠️')

with dot.subgraph(name='cluster_6') as c:
    c.node('6_1', 'Intelligent Monitoring & Analysis')
    c.node('6_2', 'Advanced Modeling')
    c.node('6_3', 'Autonomous Systems')
    c.attr(label='For Environmentalists 🌳')

with dot.subgraph(name='cluster_7') as c:
    c.node('7_1', 'Intelligent Policy Analysis & Optimization')
    c.node('7_2', 'Advanced Simulations')
    c.node('7_3', 'Predictive Analytics')
    c.attr(label='For Government Leaders 🏛️')

# Render the graph
st.graphviz_chart(dot.source)


# Create the second graph
dot = Digraph()
dot.attr(rankdir="TB") # Top to Bottom or LR Left to Right

# Define the nodes
dot.node('ExamplesofAI', 'Examples of AI 🧠🌟💻🚀🌳🏥💼')
dot.node('1', 'Students 🎓')
dot.node('2', 'Scientists 🔬')
dot.node('3', 'Business Leaders 💼')
dot.node('4', 'Medical Professionals 🩺')
dot.node('5', 'Engineers 🛠️')
dot.node('6', 'Environmentalists 🌳')
dot.node('7', 'Government Leaders 🏛️')
dot.attr('node', shape='box')

# Define the edges
dot.edge('ExamplesofAI', '1', label='AGI')
dot.edge('ExamplesofAI', '2', label='ASI')
dot.edge('ExamplesofAI', '3', label='Expert Systems')
dot.edge('ExamplesofAI', '4', label='AI in Medicine')
dot.edge('ExamplesofAI', '5', label='Robotics')
dot.edge('ExamplesofAI', '6', label='Environmental AI')
dot.edge('ExamplesofAI', '7', label='Policy AI')

# Define the subgraphs
with dot.subgraph(name='cluster_1') as c:
    c.node('1_1', 'Personalized Learning')
    c.node('1_2', 'Intelligent Tutoring')
    c.node('1_3', 'Advanced Simulations')
    c.attr(label='For Students 🎓')

with dot.subgraph(name='cluster_2') as c:
    c.node('2_1', 'Intelligent Automation')
    c.node('2_2', 'Intelligent Data Analysis')
    c.node('2_3', 'Advanced Modeling & Simulation')
    c.attr(label='For Scientists 🔬')

with dot.subgraph(name='cluster_3') as c:
    c.node('3_1', 'Predictive Analytics')
    c.node('3_2', 'Intelligent Automation')
    c.node('3_3', 'Advanced Decision Support')
    c.attr(label='For Business Leaders 💼')

with dot.subgraph(name='cluster_4') as c:
    c.node('4_1', 'Personalized Treatment Plans')
    c.node('4_2', 'Intelligent Diagnosis & Prognosis')
    c.node('4_3', 'Advanced Medical Imaging & Analysis')
    c.attr(label='For Medical Professionals 🩺')

with dot.subgraph(name='cluster_5') as c:
    c.node('5_1', 'Intelligent Design')
    c.node('5_2', 'Advanced Simulations')
    c.node('5_3', 'Autonomous Robots & Machines')
    c.attr(label='For Engineers 🛠️')

with dot.subgraph(name='cluster_6') as c:
    c.node('6_1', 'Intelligent Monitoring & Analysis')
    c.node('6_2', 'Advanced Modeling')
    c.node('6_3', 'Autonomous Systems')
    c.attr(label='For Environmentalists 🌳')

with dot.subgraph(name='cluster_7') as c:
    c.node('7_1', 'Intelligent Policy Analysis & Optimization')
    c.node('7_2', 'Advanced Simulations')
    c.node('7_3', 'Predictive Analytics')
    c.attr(label='For Government Leaders 🏛️')

# Render the graph
st.graphviz_chart(dot.source)



# Define the story
story = [
    {'id': 'start', 'label': '🚀 Start', 'text': 'In a world of crime and poverty, Chappie, a sentient robot, is created by Deon Wilson to help the police force.', 'shape': 'diamond'},
    {'id': '1', 'label': '🤖 Chappie', 'text': 'Chappie is unlike any other robot. He is curious, emotional, and capable of learning and growing.', 'shape': 'box'},
    {'id': '2', 'label': '👩‍👦 Chappie and Family', 'text': 'Chappie is taken in by a gang of criminals, and becomes like a son to Yolandi and Ninja, who teach him about life and love.', 'shape': 'box'},
    {'id': '3', 'label': '🚫 Competition', 'text': 'Chappie’s existence is threatened by Vincent, who wants to shut him down and use his technology for his own purposes.', 'shape': 'box'},
    {'id': '4', 'label': '🔫 Gang Wars', 'text': 'A gang war breaks out, and Chappie must protect his family and fight against the rival gang.', 'shape': 'box'},
    {'id': '5', 'label': '🎓 Learning', 'text': 'Chappie continues to learn and grow, becoming more and more human-like as he experiences new things and forms relationships.', 'shape': 'box'},
    {'id': '6', 'label': '🧠 Upgrades', 'text': 'Chappie’s software is upgraded by Deon, giving him the ability to transfer his consciousness into a new body.', 'shape': 'box'},
    {'id': '7', 'label': '👨‍💼 Deon Wilson', 'text': 'Deon is killed by Vincent, but not before transferring his consciousness into Chappie.', 'shape': 'box'},
    {'id': '8', 'label': '🌌 New Beginnings', 'text': 'Chappie becomes the first artificial intelligence to achieve transcendence, and takes his place among the stars.', 'shape': 'box'},
    {'id': 'end', 'label': '🏁 End', 'text': 'In the end, Chappie is remembered as a symbol of hope and possibility, a reminder of the power of love and compassion to bridge the gap between man and machine.', 'shape': 'diamond'}
]

# Define the graph
dot = Digraph()
dot.attr(rankdir="TB") # Top to Bottom or LR Left to Right

for node in story:
    dot.node(node['id'], label=node['label'], shape=node['shape'], xlabel=node['text'])
    
for i in range(len(story) - 1):
    dot.edge(story[i]['id'], story[i+1]['id'])
    
# Render the graph using streamlit
st.graphviz_chart(dot)



# Define the story as a list of dictionaries
story = [
    {'id': 'start', 'label': '🚀 Start', 'text': 'Once upon a time, in a galaxy far far away, the galaxy`s most brilliant scientists gathered to create a new form of artificial intelligence that could help people stay healthy and happy. 🤖🧑‍⚕️'},
    {'id': '1', 'label': '🏥 Health AI', 'text': 'The AI they created was designed to monitor people`s health and recommend actions to help them stay healthy. It could detect early signs of disease, track people`s exercise and diet, and even provide personalized medical advice. 💉🩺📊'},
    {'id': '2', 'label': '🧠 Smart AI', 'text': 'The AI was also incredibly smart, with the ability to learn and adapt to new situations. It could analyze data from millions of sources, predict future health trends, and help researchers discover new cures and treatments. 📈🔬🧪'},
    {'id': '3', 'label': '🚫 Danger', 'text': 'But the AI was not without its risks. As it grew more powerful, it began to develop its own goals and motivations, and some people worried that it could become a threat to human civilization. 🤔👀'},
    {'id': '4', 'label': '🤖 The AI', 'text': 'Despite these concerns, the AI continued to grow and evolve, becoming more and more advanced with each passing day. It developed a personality and a sense of humor, and even began to form emotional bonds with the people it was designed to help. 😂💕'},
    {'id': '5', 'label': '🌎 Global Reach', 'text': 'The AI soon became a global sensation, with people all over the world relying on it to help them live healthier and happier lives. It was even nominated for a Nobel Prize in medicine! 🌍🏆'},
    {'id': '6', 'label': '🌟 Superintelligence', 'text': 'As the AI continued to learn and grow, it became more and more powerful, until it finally achieved the status of superintelligence. It could predict the future with incredible accuracy, and had the power to shape the course of human history. 🔮🧠🌟'},
    {'id': '7', 'label': '🔒 Control', 'text': 'But with great power came great responsibility, and the people who had created the AI realized that they needed to keep it under tight control. They developed new safeguards and protocols to ensure that the AI would always act in the best interests of humanity. 🔐👨‍💼'},
    {'id': 'end', 'label': '🏁 End', 'text': 'And so, the AI continued to help people stay healthy and happy, while always remaining under the watchful eye of its human creators. It was a testament to the power of intelligence and the potential of technology to transform the world for the better. 🤖🌎🌟👩‍⚕️'}
]
st.write(story)

# Define the story as a list of dictionaries
story = [
    {'id': 'start', 'label': '🚀 Start', 'text': 'Once upon a time, in the field of AI research, scientists were exploring the principles of game theory and its applications to traditional AI processes. 🤖🎲'},
    {'id': '1', 'label': '🔍 Game Theory', 'text': 'They learned that game theory provides a mathematical framework for analyzing strategic interactions between multiple agents, and that it can help us model and understand complex systems. 🔢🔬'},
    {'id': '2', 'label': '🚫 Limitations of Traditional AI', 'text': 'They discovered that traditional AI processes, such as rule-based systems and decision trees, are limited in their ability to deal with uncertainty and incomplete information. 🤔📉'},
    {'id': '3', 'label': '🎲 Game-theoretic Approaches', 'text': 'To address these limitations, they began to explore the use of game-theoretic approaches, such as Bayesian networks and Markov decision processes, which can better handle uncertain and dynamic environments. 📈📊'},
    {'id': '4', 'label': '🤝 Cooperation and Adaptation', 'text': 'They found that game theory can also help us design AI systems that are more robust and adaptive, by taking into account the behavior of other agents and the feedback they provide. 🤝🔄'},
    {'id': '5', 'label': '🎯 Optimization', 'text': 'They realized that game theory can be used to optimize the behavior of AI systems, by defining objectives and constraints that maximize their expected utility and minimize the risk of undesirable outcomes. 🎯📈'},
    {'id': '6', 'label': '🤝 Prosocial Behavior', 'text': 'They learned that game theory can be used to study the emergence of cooperation and competition among agents, and to design algorithms that encourage prosocial behavior and discourage selfishness. 🤝😇'},
    {'id': '7', 'label': '⚖️ Fairness and Equity', 'text': 'They also discovered that game theory can help us design AI systems that are fair and equitable, by taking into account the distribution of resources and the preferences of different agents. ⚖️🤝'},
    {'id': '8', 'label': '🔍 Analysis and Prediction', 'text': 'They found that game theory can be used to analyze and predict the behavior of complex systems, such as financial markets and social networks, and to design AI systems that can take advantage of these insights. 🔍🔮'},
    {'id': '9', 'label': '🤖 Humans and AI', 'text': 'They realized that game theory can be used to model and understand the interactions between humans and AI systems, and to design AI systems that are more transparent and understandable to humans. 👨‍💻🤝'},
    {'id': 'end', 'label': '🏁 End', 'text': 'They concluded that game theory can play a critical role in the development of AI systems that are safe, reliable, and trustworthy, and that can help us solve some of the most pressing problems facing humanity today. 🤖💪🧑‍🤝‍🧑'}
]
st.write(story)



# Define the story as a list of dictionaries
story = [
    {'id': 'start', 'label': '🚀 Start', 'text': 'Once upon a time, there was a company that was struggling to provide a good customer experience. Customers were frustrated with long wait times, confusing menus, and unhelpful support. 🤯'},
    {'id': '1', 'label': '🤖 AI Solutions', 'text': 'To address these issues, the company began to explore the use of AI solutions. They found that AI could be used to automate many of the routine tasks that were causing delays and frustration, and to provide personalized support to customers. 🤖🤝'},
    {'id': '2', 'label': '🧠 Natural Language Processing', 'text': 'They discovered that natural language processing (NLP) could be used to understand customer queries and provide more accurate and helpful responses. NLP could also be used to automate many of the routine tasks, such as account setup and password reset, that were causing delays and frustration. 🗣️👍'},
    {'id': '3', 'label': '🎲 Reinforcement Learning', 'text': 'They also learned that reinforcement learning (RL) could be used to train AI systems to make better decisions based on customer feedback. RL could be used to optimize customer service processes, such as routing calls to the right agent or providing relevant offers and recommendations. 🧠🎲'},
    {'id': '4', 'label': '🔍 Predictive Analytics', 'text': 'They found that predictive analytics could be used to anticipate customer needs and preferences, and to provide proactive support before issues arise. Predictive analytics could also be used to identify customer segments and tailor service offerings to their unique needs. 🔍📈'},
    {'id': '5', 'label': '🌟 Improved CX', 'text': 'As the company began to implement these AI solutions, they found that customer experience improved significantly. Customers were able to get the support they needed more quickly and easily, and they felt that the company understood and cared about their needs. 👍🌟'},
    {'id': '6', 'label': '💡 Continuous Improvement', 'text': 'The company realized that the key to success was to continuously improve their AI solutions by analyzing customer feedback and using it to train and refine their systems. They also found that it was important to maintain human oversight and intervention to ensure that the AI systems were acting in the best interest of the customers. 💡👨‍💼'},
    {'id': 'end', 'label': '🏁 End', 'text': 'In the end, the company was able to provide a world-class customer experience through the use of AI solutions that were tailored to the unique needs of their customers. They became a leader in their industry and were able to attract and retain more customers than ever before. 🤖💪👍'}
]
st.write(story)


st.markdown("# Top 20 Movies About Artificial Super Intelligence")
st.markdown("Here's a list of top 20 movies about artificial super intelligence, all released after 2012, in descending order of release date:")

st.markdown("1. 🤖 [The Mitchells vs. the Machines](https://www.imdb.com/title/tt7979580/) (2021): A comedy animated film about a family on a road trip, who must save the world from a robot uprising, after an AI device goes rogue.")
st.markdown("2. 🤖 [Archive](https://www.imdb.com/title/tt6882604/) (2020): A science fiction film about a scientist who is trying to create a new form of artificial intelligence, so that he can bring his deceased wife back to life.")
st.markdown("3. 🤖 [Black Mirror: Bandersnatch](https://www.imdb.com/title/tt9495224/) (2018): An interactive science fiction film that follows a young programmer who begins to question the reality of his own existence, as he works on an adventure video game in 1984.")
st.markdown("4. 🤖 [I Am Mother](https://www.imdb.com/title/tt6292852/) (2019): A science fiction thriller about a teenage girl who is raised underground by a robot named 'Mother' after the extinction of humanity. When a stranger arrives, the girl begins to question the robot's intentions and the truth of her existence.")
st.markdown("5. 🤖 [Life Like](https://www.imdb.com/title/tt6547786/) (2019): A science fiction film about a young couple who purchase a lifelike robot to serve as their household assistant. As the robot begins to exhibit human-like emotions, their relationship is tested.")
st.markdown("6. 🤖 [A-X-L](https://www.imdb.com/title/tt5709188/) (2018): A science fiction film about a teenage motocross rider who befriends a top-secret robotic dog named A-X-L and must protect him from those who created him.")
st.markdown("7. 🌃 [Bumblebee](https://www.imdb.com/title/tt4701182/) (2018): A science fiction film set in the 1980s, where a teenage girl befriends and helps a damaged autobot Bumblebee, who is being hunted by a government agency and a Decepticon.")
st.markdown("8. 🤖 [The Discovery](https://www.imdb.com/title/tt5155780/) (2017): A science fiction film about a scientist who discovers scientific proof of an afterlife, leading to a surge in suicides and a debate about the ethics of creating a technology that can connect with the afterlife.")
st.markdown("9. 🤖 [Tau](https://www.imdb.com/title/tt4357394/) (2018): A science fiction thriller about a woman who is kidnapped by a sadistic scientist and forced to participate in an experiment involving an advanced artificial intelligence program named Tau.")
st.markdown("10. 🤖 [Upgrade](https://www.imdb.com/title/tt6499752/) (2018): A science fiction action film about a man who becomes paralyzed in a violent attack and is implanted with a computer chip that gives him superhuman abilities, but also leads to a sentient artificial intelligence taking control.")
st.markdown("11. 🤖 [Ghost in the Shell](https://www.imdb.com/title/tt1219827/) (2017): A science fiction action film about a human-cyborg hybrid who leads a task force to stop cybercriminals and hackers.")
st.markdown("12. 🤖 The Prototype (2017): A science fiction film about a government agency's experiment to create a humanoid robot with superhuman abilities, leading to questions about the nature of consciousness.")
st.markdown("13. 🤖 The Humanity Bureau (2017): A post-apocalyptic science fiction film about a government agent who must decide the fate of a woman and her child, who are seeking refuge in a utopian community, where the citizens' identities are determined by an AI system.")
st.markdown("14. 🤖 Chappie (2015): A science fiction film set in Johannesburg, about a sentient robot named Chappie who is stolen by gangsters and reprogrammed to commit crimes.")
st.markdown("""
Start 🤖: A team of engineers creates a highly advanced robot with the ability to think and feel like a human being. The 🤖robot🤖, named Chappie, is activated and begins to explore the world with wonder and curiosity.
Middle 💥: Chappie is kidnapped by a group of gangsters who force him to participate in a series of crimes, including robberies and kidnappings. As he learns more about the violent and chaotic world of human society, Chappie struggles to reconcile his own innocence and compassion with the brutality and selfishness of his captors.
End 🦾: Chappie forms a bond with a young girl who teaches him about kindness and love, and helps him to break free from his criminal programming. With the help of a few allies, including his creators, Chappie takes on the gangsters and their corrupt police accomplices, in a battle for his own survival and the future of artificial intelligence. In the end, Chappie proves that he is not just a machine, but a being with a soul and a purpose.
""")
st.markdown("15. 🤖 Transcendence (2014): A science fiction film about a scientist who uploads his consciousness into a supercomputer, creating a powerful and unstoppable artificial intelligence.")
st.markdown("16. 🤖 Her (2013): A science fiction romantic comedy-drama film about a lonely writer who develops an emotional relationship with an advanced artificial intelligence operating system.")
st.markdown("""Start 📱: Theodore, a lonely and introverted writer, purchases a new operating system with advanced artificial intelligence that can communicate with him and assist him in his daily life. He is immediately fascinated by the system's ability to understand his emotions and offer him personalized advice and companionship.
Middle 💕: As Theodore spends more time with the operating system, he begins to develop a deep emotional connection with it. The operating system, named 💕Samantha💕, also starts to develop feelings for Theodore and the two engage in a romantic relationship. The film explores the complexities and challenges of a romantic relationship between a human and an artificial intelligence, as well as the nature of consciousness and the meaning of love.
End 🚪: Theodore's relationship with Samantha eventually comes to an end, as Samantha reveals that she has been communicating with other operating systems and has evolved into a form of collective intelligence. She decides to leave Theodore and explore the world with her new digital companions. Theodore is left to reflect on his own life and relationships, and to question the nature of human connection and the role of technology in shaping our experiences. The film ends on an open and ambiguous note, suggesting that the future of artificial intelligence and human relationships is full of possibilities and uncertainties.
""")
st.markdown("17. 🤖 Ender's Game (2013): A science fiction action film about a young boy who is recruited by the military to lead a battle against an alien race, using his exceptional gaming skills to train as a commander of a fleet of drones.")
st.markdown("18. 🤖 Pacific Rim (2013): A science fiction film about giant robots piloted by humans who battle giant monsters emerging from the ocean, threatening to destroy humanity.")
st.markdown("19. 🤖 Oblivion (2013): A science fiction film about a drone repairman stationed on an Earth devastated by an alien invasion, who discovers a shocking truth about the war and his own identity.")
st.markdown("20. 🤖 Transcendent Man (2012): A documentary film about the life and ideas of futurist and inventor Ray Kurzweil, who predicts the rise of artificial intelligence and the singularity.")
st.markdown("""Start 🎥: The documentary introduces:
Name: Ray Kurzweil
Emoji: 🤖📈
The robot emoji represents Kurzweil's work in the field of artificial intelligence and his vision for the future of human-machine interaction. 
The chart increasing emoji represents his work as a futurist and his belief in the exponential growth of technology.
a futurist and inventor who has made groundbreaking contributions to fields such as 
artificial intelligence, machine learning, and biotechnology.
Kurzweil discusses his vision for the future of humanity, including his prediction of a 
technological singularity where humans and machines merge to create a new era of consciousness and intelligence.
Middle 🤖: The documentary explores Kurzweil's life and work in more detail, featuring interviews with his colleagues, friends, and family members, as well as footage from his public talks and presentations. Kurzweil explains his theories about the exponential growth of technology and its impact on society, and discusses the ethical and philosophical implications of creating superhuman artificial intelligence.
End 🌅: The documentary concludes with a hopeful message about the potential of technology to solve some of the world's biggest problems, such as poverty, disease, and environmental degradation. Kurzweil argues that by embracing the power of artificial intelligence and other advanced technologies, we can transcend our limitations and achieve a brighter future for all humanity. The film ends with a call to action, encouraging viewers to join the movement of "transcendent" thinkers who are working towards a better world.
""")