import gradio as gr
from transformers import pipeline
from huggingface_hub import login
import os

api_key = os.getenv("api_key_read")
model = os.getenv("model_repo")
login(api_key)
pipe = pipeline(
    "audio-classification",
    model=model,
    chunk_length_s = 30,
    stride_length_s = 5,
    batch_size = 1,
    api_key = api_key,
)

examples = []
for file in os.listdir("examples"):
    examples.append(f'examples//{file}')

def classify_audio(filepath):
    preds = pipe(filepath)
    outputs = {}
    for p in preds:
        outputs[p["label"]] = p["score"]
    return outputs

import gradio as gr

demo = gr.Interface(
    fn=classify_audio, inputs=gr.Audio(type="filepath"),examples = examples, outputs=gr.outputs.Label()
)
demo.launch(debug=True)