sum_app_text_tab_1= """
<h2><center> The Summarization Task  </center></h2>

The goal of text summarization is to condense long documents into summaries, while maintaining key information found within the original text document. This is one of the most challenging NLP tasks as it requires a range of abilities, such as understanding long passages and generating coherent text that captures the main topics in a document. However, when done well, text summarization is a powerful tool that can speed up various business processes by relieving the burden of domain experts to read long documents in detail.

Text summarization methods can either be used as an extractive or abstractive model. An Extractive method does what it sounds like, it concatenates different important sentences or paragraphs without understanding the meaning of those parts. Extractive summarization does not create any new word phrases. For instance,  if you presented a page of text to an extractive model, it would just act as a text “highlighter”, see Figure 1. However, Abstractive summarization generates text in a fashion that tries to guess the meaning in a summarised way of the page of text it is presented. It would put words together in a meaningful way and add the most important fact found in the text. 

<figure>
  <img src="file/EX_VS_ABS.png" alt="EX_VS_ABS" style="width:100%">
  <figcaption style="text-align: center;">Figure 1 - The two different approaches to text summarization: Extractive and Abstractive.</figcaption>
</figure>

<h3><center> Abstractive Model </center></h3>

The underlying engines for the Abstractive part are transformer based model BART, a sequence-to-sequence model with a bidirectional (BERT-like) encoder and an autoregressive (GPT-like) decoder. The BART-model was pre-trained by KBLab/bart-base-swedish-cased (link) to learn general knowledge about language. Afterwards, the model was further fine-tuned on two labelled datasets that have been open-sourced:

- [Gabriel/xsum_swe](https://huggingface.co/datasets/Gabriel/xsum_swe)
- [Gabriel/cnn_daily_swe](https://huggingface.co/datasets/Gabriel/cnn_daily_swe)

To see more in depth regarding the training go to model card: [Gabriel/bart-base-cnn-xsum-swe](https://huggingface.co/Gabriel/bart-base-cnn-xsum-swe). The core idea behind the training procedure is sequential adoption through transfer learning, i.e multiple phases for fine-tuning a pre-trained model on different datasets. It should be noted that the MT datasets will not teach the model Swedish perfectly, but it will give a more ideal basis to further fine-tune on a more domain specific use case. For more information on this topic read:  [Sequential Adoption](https://arxiv.org/pdf/1811.01088v2.pdf)
"""
      
sum_app_text_tab_2= """ 
<h2><center> 🤗  </center></h2>

Figure 2 below illustrates how the skill level of the model increases at each step:

<figure>
  <img src="file/BART_SEQ.png" alt="BART_SEQ" style="width:100%">
  <figcaption style="text-align: center;"> Figure 2 - A model progression between on 3 aspects during sequential adoption: domain language, task and language..</figcaption>
</figure>

The main benefits of transfer learning in general include the saving of resources and improved efficiency when training new models, so feel free to adopt this model for your type of problem! 

<h3><center> Extractive Model  </center></h3>

The extractive models for this app are using sentence-transformer models, which basically is a bi-encoder that determines how similar two sentences are. This type of models convert texts into vectors (embedding) that capture semantic information. Additionally, LexRank, an unsupervised graph-based algorithm, is used to determine centrality scores as a post-process step to summarise. The main idea is that sentences "recommend" other similar sentences to the reader. Thus, if one sentence is very similar to many others, it will likely be a sentence of great importance. The importance of this sentence also stems from the importance of the sentences "recommending" it. Thus, to get ranked highly and placed in a summary, a sentence must be similar to many sentences that are in turn also similar to many other sentences. 

<figure>
  <img src="file/Lex_rank.png" alt="Lex_rank" style="width:100%">
  <figcaption style="text-align: center;"> Figure 3 - The right similarity graphs connection have been filtered with a corresponding threshold.</figcaption>
</figure>

Figure 3 above showcase how LexRank formats similarity graphs based on all possible sentence combinations sentence similarity from the vector embeddings. Notice that the most "recommended" sentences that are extracted (the right graph) are derived from a threshold value which filters "weaker" connections in the similarity graph.
For more information on this topic read: [LexRank](https://www.aaai.org/Papers/JAIR/Vol22/JAIR-2214.pdf)
"""         

abstractive_example_text_1= """Frankrike lås Sebastien Chabal har nämnts för en farlig tackling på Englands Simon Shaw under lördagens VM semifinal i Paris. Simon Shaw lastar av trots att Raphael Ibanez, vänster, och Sebastien Chabal. Sale Sharks framåt kommer att ställas inför en disciplinär utfrågning på måndag efter hans tackling på motsatt andra-rower Shaw noterades genom att citera kommissionär Dennis Wheelahan. Chabal började matchen på ersättningsbänken, men kom i 26: e minuten att ersätta den skadade Fabien Pelous under värd Frankrikes 14-9 nederlag. Om han blir avstängd missar Chabal fredagens tredje och fjärde match på Parc des Princes. Samtidigt, Frankrike tränare Bernard Laporte sade att nederlaget var svårare att ta än Englands 24-7 seger i 2003 semifinalen. "År 2003 var de bättre än oss. I själva verket var de bättre än alla", sade Laporte, som lämnar sin roll att tillträda posten som junior idrottsminister i den franska regeringen. "De var som Nya Zeeland i denna turnering - favoriten, förutom att de gick hela vägen. Den här gången är det svårare för igår var det 50-50." Samtidigt, England -- försöker bli den första nationen att försvara VM-titeln -- avslöjade att stjärna kicker Jonny Wilkinson återigen hade problem med matchbollarna under semifinalen. Flughalvan, som uttryckte sin oro efter att ha kämpat med stöveln mot Australien, avvisade en boll innan han sparkade en vital trepoängare mot Frankrike. "Vi sa det inte förra veckan men en icke-match bollen kom ut på fältet i Marseille som Jonny sparkade," chef för rugby Rob Andrew sade. "Han tänkte inte på det när han sparkade det. Matchbollarna är märkta, numrerade ett till sex. Igår kväll hade de "World Cup semifinal England vs Frankrike" skrivet på dem. På matchkvällen var Jonny vaksam när han sparkade för mål att de faktiskt var matchbollar han sparkade. "Träningsbollarna förlorar tryck och form. Hela frågan förra veckan, arrangörerna accepterade alla sex matchbollar bör användas av båda sidor på torsdagen före matchen. " E-post till en vän."""

abstractive_example_text_2="""Man enades om målet för ett stimulanspaket värt nästan 39 miljoner pund som en del av den walesiska regeringens budgetavtal med liberaldemokraterna. Finansminister Jane Hutt sa att det skulle bidra till att skapa omedelbara fördelar för ekonomin. Men Plaid Cymru sade att det var "helt otillräckligt" och de konservativa sade att det skulle gå till rådet skattebetalare. Labour och Lib Dems tillkännagav ett budgetavtal på fredag kväll och avslutade veckor av förhandlingar mellan ministrar och oppositionspartier. Med 30 av församlingens 60 platser behöver Labour hjälp av minst en annan part för att godkänna sina utgiftsplaner. Den 38,9 miljoner pund stora nedgången - som skulle tillbringas över två år - utgjorde också en del av budgetdiskussionerna. Pengarna kommer från statskassan till följd av ett skattestopp i England. Ett program för att hjälpa företag att anställa unga rekryter finns bland projekt som får finansiering. Regeringen sa att en extra £4.9m skulle skapa 1800 fler lärlingsplatser. Omkring 9 miljoner pund kommer att gå till att uppgradera skolbyggnader, med samma belopp som spenderas på att leverera ytterligare 130 bostäder. Regeringen kommer att spendera £3.5 förbättra vägar på platser där den planerar att skapa företagsområden. Fem delar av Wales har öronmärkts som områden där företag kommer att få hjälp att växa. Förste minister Carwyn Jones har sagt att kopiera den brittiska regeringen genom att använda pengarna för att hålla nere rådets skatt skulle inte i någon större utsträckning gynna ekonomin, tillägger att skatteräkningar för band D hem var lägre i genomsnitt i Wales. Labour har kritiserats av motståndare, särskilt Plaid Cymru, för att inte göra tillräckligt för att reagera på en försämrad ekonomisk situation. Hutt pekade på andra åtaganden från regeringens sida som syftar till att främja tillväxten. Hon sa att hon hade övervägt förslag om att spendera pengarna från hela regeringen. Hon sade: "Detta paket bygger på dessa åtgärder för att stimulera ekonomin och utveckla offentliga tjänster, vilket ger omedelbara fördelar för vår ekonomi samtidigt som det kompletterar våra långsiktiga mål." Konservativ skuggfinansminister Paul Davies sade att han var besviken ministrar använde ytterligare resurser för att "stoppa upp" befintlig politik. Han sade: "Det finns inget nytt i detta paket annat än ett nytt försök av walesiska arbetsmarknadsministrar att agera på ekonomin, samtidigt som man spenderar pengar som skulle användas bättre av skattebetalarna själva." Welsh Lib Dem ledare Kirsty Williams sade att hennes parti kommer också att arbeta med regeringen om hur man ska spendera eventuella pengar som tilldelats Wales som ett resultat av tisdagens höst uttalande av förbundskansler George Osborne. "Wales Liberal Democrats strategi kommer att vara att fortsätta att få vår ekonomi i rörelse och förbättra livskvaliteten för människor i Wales", sade hon. Plaid Cymru ekonomi talesman Alun Ffred Jones sade: " I över sex månader har Labour lutat sig tillbaka och inte gjort någonting - utsätta Wales för den fulla kraften i denna ekonomiska kris. "Nu försöker de desperat att skapa intrycket att denna lilla summa pengar kommer att göra vad som behövs. Helt enkelt kommer det inte att göra det."""

extractive_example_text_1= """Man enades om målet för ett stimulanspaket värt nästan 39 miljoner pund som en del av den walesiska regeringens budgetavtal med liberaldemokraterna. Finansminister Jane Hutt sa att det skulle bidra till att skapa omedelbara fördelar för ekonomin. Men Plaid Cymru sade att det var "helt otillräckligt" och de konservativa sade att det skulle gå till rådet skattebetalare. Labour och Lib Dems tillkännagav ett budgetavtal på fredag kväll och avslutade veckor av förhandlingar mellan ministrar och oppositionspartier. Med 30 av församlingens 60 platser behöver Labour hjälp av minst en annan part för att godkänna sina utgiftsplaner. Den 38,9 miljoner pund stora nedgången - som skulle tillbringas över två år - utgjorde också en del av budgetdiskussionerna. Pengarna kommer från statskassan till följd av ett skattestopp i England. Ett program för att hjälpa företag att anställa unga rekryter finns bland projekt som får finansiering. Regeringen sa att en extra £4.9m skulle skapa 1800 fler lärlingsplatser. Omkring 9 miljoner pund kommer att gå till att uppgradera skolbyggnader, med samma belopp som spenderas på att leverera ytterligare 130 bostäder. Regeringen kommer att spendera £3.5 förbättra vägar på platser där den planerar att skapa företagsområden. Fem delar av Wales har öronmärkts som områden där företag kommer att få hjälp att växa. Förste minister Carwyn Jones har sagt att kopiera den brittiska regeringen genom att använda pengarna för att hålla nere rådets skatt skulle inte i någon större utsträckning gynna ekonomin, tillägger att skatteräkningar för band D hem var lägre i genomsnitt i Wales. Labour har kritiserats av motståndare, särskilt Plaid Cymru, för att inte göra tillräckligt för att reagera på en försämrad ekonomisk situation. Hutt pekade på andra åtaganden från regeringens sida som syftar till att främja tillväxten. Hon sa att hon hade övervägt förslag om att spendera pengarna från hela regeringen. Hon sade: "Detta paket bygger på dessa åtgärder för att stimulera ekonomin och utveckla offentliga tjänster, vilket ger omedelbara fördelar för vår ekonomi samtidigt som det kompletterar våra långsiktiga mål." Konservativ skuggfinansminister Paul Davies sade att han var besviken ministrar använde ytterligare resurser för att "stoppa upp" befintlig politik. Han sade: "Det finns inget nytt i detta paket annat än ett nytt försök av walesiska arbetsmarknadsministrar att agera på ekonomin, samtidigt som man spenderar pengar som skulle användas bättre av skattebetalarna själva." Welsh Lib Dem ledare Kirsty Williams sade att hennes parti kommer också att arbeta med regeringen om hur man ska spendera eventuella pengar som tilldelats Wales som ett resultat av tisdagens höst uttalande av förbundskansler George Osborne. "Wales Liberal Democrats strategi kommer att vara att fortsätta att få vår ekonomi i rörelse och förbättra livskvaliteten för människor i Wales", sade hon. Plaid Cymru ekonomi talesman Alun Ffred Jones sade: " I över sex månader har Labour lutat sig tillbaka och inte gjort någonting - utsätta Wales för den fulla kraften i denna ekonomiska kris. "Nu försöker de desperat att skapa intrycket att denna lilla summa pengar kommer att göra vad som behövs. Helt enkelt kommer det inte att göra det."""