from __future__ import division, print_function
from six import StringIO
from svgpath2mpl import parse_path
from collections import defaultdict
import xml.etree.ElementTree as etree
import re
import matplotlib as mpl
import matplotlib.pyplot as plt
import numpy as np
import requests
import pandas as pd
import datetime

import warnings
warnings.filterwarnings("ignore")

def calling_map_viz(counts_df):
    r = "svg/snazzy-image-01.svg"
    tree = etree.parse(r)
    root = tree.getroot()
    path_elems = root.findall('.//{http://www.w3.org/2000/svg}path')

    paths = [parse_path(elem.attrib['d']) for elem in path_elems]
    facecolors = []
    edgecolors = []
    linewidths = []
    for elem in path_elems:
        facecolors.append(dict(item.split(":") for item in elem.attrib.get('style', 'none').split(";")).get("fill", "none"))
        edgecolors.append(dict(item.split(":") for item in elem.attrib.get('style', 'none').split(";")).get("stroke", "none"))
        linewidths.append(dict(item.split(":") for item in elem.attrib.get('style', 'none').split(";")).get("stroke-width", "none").replace("px", ""))

    path_id = defaultdict(int)
    for i, elem in enumerate(path_elems):
        try:
            #print(i, elem.attrib['id'])
            path_id[elem.attrib['id']] = i
        except:
            continue


    # counts_df = pd.read_csv("counts_dataset.csv")
    counts_df['total'] = counts_df['car'] + counts_df['motorcycle'] + counts_df['large_vehicle']
    count_max = counts_df['total'][-200:].max()
    count_min = counts_df['total'][-200:].min()
    last_date = counts_df.iloc[-1:,0].values[0]
    last_time = counts_df.iloc[-1:,1].values[0]


    count_dict = {"woodlands_to_sg" :counts_df.loc[counts_df['view'].str.contains(r'''Woodlands([a-zA-Z0-9_.+-]+)sg''') & (counts_df['date'] == last_date) & (counts_df['time'] == last_time), "total" ].sum(),
                  "woodlands_to_jh" :counts_df.loc[counts_df['view'].str.contains(r'''Woodlands([a-zA-Z0-9_.+-]+)jh''') & (counts_df['date'] == last_date) & (counts_df['time'] == last_time), "total" ].sum(),
                  "tuas_to_sg" :counts_df.loc[counts_df['view'].str.contains(r'''Tuas([a-zA-Z0-9_.+-]+)sg''') & (counts_df['date'] == last_date) & (counts_df['time'] == last_time), "total" ].sum(),
                  "tuas_to_jh" :counts_df.loc[counts_df['view'].str.contains(r'''Tuas([a-zA-Z0-9_.+-]+)jh''') & (counts_df['date'] == last_date) & (counts_df['time'] == last_time), "total" ].sum()
                  }

    values = np.array([0., 0.5, 1.])
    values = np.sort(np.array(values))
    values = np.interp(values, (values.min(), values.max()), (0., 1.))
    colors = ["#539f6b", "#ffc835", "#bf0000"]
    cmap = mpl.colors.LinearSegmentedColormap.from_list("custom", list(zip(values, colors)))

    norm = mpl.colors.Normalize(vmin=count_min, vmax=count_max)

    hex_dict = {k: mpl.colors.to_hex(cmap(norm(v))) for k, v in count_dict.items()}
    color_dict = defaultdict(str)

    for k, i in path_id.items():
        color_dict[i] = hex_dict[k]

    for k, i in color_dict.items():
        #print(k,i)
        facecolors[k] = i

    collection = mpl.collections.PathCollection(paths, 
                                          edgecolors=edgecolors, 
                                          linewidths=[int(i)/100 for i in linewidths if i != 'none'],
                                          facecolors=[i.strip() for i in facecolors])



    fig = plt.figure(figsize=(10,10))
    ax = fig.add_subplot(111)
    collection.set_transform(ax.transData)
    ax.add_artist(collection)
    ax.set_xlim([100, 1900])
    ax.set_ylim([1800, 0])
    ax.set_title(datetime.datetime.strptime(last_date, '%Y-%m-%d').strftime('%a, %d %B %Y') + " | " + last_time + " SGT", fontname = 'Georgia')
    return fig