import streamlit as st
import pandas as pd
import plotly.express as px
from datasets import load_dataset
import os

def basic_chart(counts_df, plot, hovermode = False):

    # data processing
    counts_df["traffic"] = (
        counts_df["car"] + counts_df["motorcycle"] + counts_df["large_vehicle"]
    )
    counts_df["datetime"] = pd.to_datetime(counts_df["date"] + " " + counts_df["time"])
    counts_df["weekday"] = counts_df["datetime"].dt.strftime("%A")
    counts_df["hour"] = counts_df["datetime"].dt.strftime("%H")

    # print (counts_df.head())

    # get the mean by the weekday
    date_view = counts_df.groupby(by=["view", "weekday"]).mean().round(1)
    date_view = date_view.reset_index()

    # get the mean by the time
    time_view = counts_df.groupby(by=["view", "hour"]).mean().round(1)
    time_view = time_view.reset_index()

    # conditional views
    if plot == "Day":
        # filtered_view_day = date_view[date_view["view"] == view]
        fig = px.bar(
            date_view,
            x="weekday",
            y="traffic",
            category_orders = {'weekday': ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday']},
            labels={
                "weekday": "Day",
                "traffic": "Traffic",
            },
        )
        fig.update_layout(
            yaxis_visible=True, yaxis_showticklabels=False, hovermode=hovermode, xaxis_title = '', yaxis_title = ''
        )
    elif plot == "Hour":
        # filterd_view_time = time_view[time_view["view"] == view]
        fig = px.bar(
            time_view,
            x="hour",
            y="traffic",
            labels={
                "hour": "Hour",
                "traffic": "Traffic",
            },
        )
        fig.update_layout(
            yaxis_visible=True, yaxis_showticklabels=False, hovermode=hovermode
        )
        fig.update_xaxes(tickmode = 'linear', type = 'category')
    elif plot == "Raw":
        # filtered_views = counts_df[counts_df["view"] == view]
        fig = px.bar(
            counts_df,
            x="datetime",
            y="traffic",
            labels={
                "datetime": "Date and Time",
                "traffic": "Traffic",
            },
        )
        fig.update_layout(
            yaxis_visible=True, yaxis_showticklabels=False, hovermode=hovermode
        )

    return fig
