---
title: Causion
emoji: 🚀
colorFrom: blue
colorTo: indigo
sdk: streamlit
sdk_version: 1.17.0
app_file: app.py
pinned: false
---

Check out the configuration reference at https://huggingface.co/docs/hub/spaces-config-reference

## View the App - https://huggingface.co/spaces/GT6242Causion/Causion

## To clone the repo - 
```
git clone https://huggingface.co/spaces/GT6242Causion/Causion
```

## To set up your environment to run it locally

### Important - assumes you have Ana/Miniconda on your machine

1. After cloning the repo, open your terminal in the folder or open the terminal and navigate to your folder
```
cd path/to/folder/Causion
```
2. Use the conda environment management to create your environment

```
conda env create -f env.yml --name Causion
```

3. Activate the Environment 
```
conda activate Causion
```

4. You can now run your streamlit app locally. See Below segment "Running Streamlit App locally" for further details

## To add, commit and push your development: 

```
git add . # this will add all the files you committed but that is probably not what you want to do
git commit -m "<your message here>" 
git push
```

## Running Streamlit App locally

The usual command for running the steamlit app is as follows:

1. Open your terminal in the folder or open the terminal and navigate to your folder
```
cd path/to/folder/Causion
```

2. Run streamlit app
```
streamlit run app.py
```

However, before running your app, you have to make sure you have the dataset with you. 

There are two ways to make sure of this
1. Pull dataset right from HuggingFace Spaces Dataset - always streaming in the new data, but need to add into temp Environment variable every time. This is default because our app has to stream in the data
2. Download the dataset and run locally in the data folder - Easier to setup, but always have to download the dataset. Also need to set the data code back to default every time. 

For option #1, you do not need to change anything in the script. You just need to have an additional line to add environment variable in your terminal:

Powershell: 
```
$env:TOKEN = "<insert TOKEN secret here>"
```
