# Supported molecular properties


### Instability
Compute the protein instability as presented in [Guruprasad et al. (*Protein Engineering, Design and Selection*; 1990)](https://academic.oup.com/peds/article-abstract/4/2/155/1491271).

### Aromaticity
Compute the protein aromaticity as presented in [Lobry et al. (*Nucleic Acid Research*; 1994)](https://academic.oup.com/nar/article-abstract/22/15/3174/1087817).

### Isoelectric point
Computes the isoelectric point of every residue and aggregates.

### Hydrophobicity
"Computes the hydrophobicity of a protein, relative freq. of **A,C,F,I,L,M & V**.

### Aliphaticity
Compute the aliphatic index of globular proteins as presented in [Ikai (*The Journal of Biochemistry*; 1980)](https://academic.oup.com/jb/article-abstract/88/6/1895/773432).

### Charge
Compute the charge of a protein, based on a boolean for the amide (whether the sequences are C-terminally amidated) and a pH value; as presented in [Bjellqvist, (*Electrophoresis*; 1993)](https://analyticalsciencejournals.onlinelibrary.wiley.com/doi/abs/10.1002/elps.11501401163).

### Charge Density
Computes the charge density of a protein, based on a boolean for the amide (whether the sequences are C-terminally amidated) and a pH value; as presented in [Bjellqvist, (*Electrophoresis*; 1993)](https://analyticalsciencejournals.onlinelibrary.wiley.com/doi/abs/10.1002/elps.11501401163).

### Boman index
Compute the protein aromaticity as presented in [Boman (*Journal of internal medicine*; 2003)](https://onlinelibrary.wiley.com/doi/full/10.1046/j.1365-2796.2003.01228.x).

### Protein weight
Compute the molecular weight of a protein with [RDKit](https://www.rdkit.org/docs/GettingStartedInPython.html).

### Length
Retrieves the number of residues of a protein.

Moreover, GT4SD also includes properties on other entities such as [molecules](https://gt4sd.github.io/gt4sd-core/api/gt4sd.properties.molecules.html) and [crystals](https://gt4sd.github.io/gt4sd-core/api/gt4sd.properties.crystals.html).
The GT4SD web app for molecules can be found [here](https://huggingface.co/spaces/GT4SD/molecular_properties)
