# Supported molecular properties


### ClinTox
A [ToxSmi model](https://github.com/PaccMann/toxsmi) trained on [ClinTox](https://moleculenet.org/datasets-1) dataset which has two endpoints: Probability of FDA approval and Probability of failure in clinical trials. For details see [Born et al., (2023; *Digital Discovery*)](https://pubs.rsc.org/en/content/articlelanding/2023/dd/d2dd00099g)

### SIDER
A [ToxSmi model](https://github.com/PaccMann/toxsmi) trained on the [SIDER](https://moleculenet.org/datasets-1) dataset for 27 different types of side effects of drugs. For details see [Born et al., (2023; *Digital Discovery*)](https://pubs.rsc.org/en/content/articlelanding/2023/dd/d2dd00099g)

### Tox21
A [ToxSmi model](https://github.com/PaccMann/toxsmi) trained on the [Tox21](https://tripod.nih.gov/tox/) dataset with 12 different types of environmental toxicities. For details see [Born et al., (2023; *Digital Discovery*)](https://pubs.rsc.org/en/content/articlelanding/2023/dd/d2dd00099g)

### SCScore
Predict the synthetic complexity score (SCScore) as presented in [Coley et al. (*J. Chem. Inf. Model.*; 2018)](https://pubs.acs.org/doi/full/10.1021/acs.jcim.7b00622).

### SAS
Estimate the synthetic accessibility score (SAS) as presented in [Ertl et al. (*Journal of Chemoinformatics*; 2009)](https://jcheminf.biomedcentral.com/articles/10.1186/1758-2946-1-8).

### Lipinski
Measure whether a molecule confirms to the Lipinski-rule-of-five as presented in [Lipinski et al. (*Advanced Drug Delivery Reviews*; 2001)](https://www.sciencedirect.com/science/article/abs/pii/S0169409X00001290?via%3Dihub).

### Penalized logP
Measure the penalized logP (partition coefficient) score as presented in [Gomez-Bombarelli et al. (*ACS Central Science*; 2018)](https://arxiv.org/abs/1610.02415v1). This is the logP minus the number of rings with > 6 atoms minus the SAS.

### QED
Measure the drug-likeness as presented in [Bickerton et al. (*Nature Chemistry*; 2012)](https://www.nature.com/articles/nchem.1243).

### LogP
Measure the logP (partition coefficient) of a molecule as presented in [Wildman et al. (*J. Chem. Inf. Comput. Sci.*; 1999)](https://pubs.acs.org/doi/full/10.1021/ci990307l).

### Bertz
Calculate the total polar surface area of a molecule as presented in [Ertl et al. (*Journal of Medicinal Chemistry*; 2000)](https://pubs.acs.org/doi/full/10.1021/jm000942e).

### TPSA
Calculate the first general index of molecular complexity [Bertz (*Journal of the American Chemical Society*; 1981)](https://pubs.acs.org/doi/pdf/10.1021/ja00402a071).

### Is-Scaffold
Whether the molecule is identical to its [Murcko scaffold](https://rdkit.org/docs/source/rdkit.Chem.Scaffolds.MurckoScaffold.html).

### Number-Of-X
Calculated with [RDKit](https://www.rdkit.org/docs/source/rdkit.Chem.rdchem.html).

### Molecular Weight
Calculated with [RDKit](https://www.rdkit.org/docs/source/rdkit.Chem.rdchem.html).


### ToxSmi citation
```bib
@article{born2023chemical,
    author = {Born, Jannis and Markert, Greta and Janakarajan, Nikita and Kimber, Talia B. and Volkamer, Andrea and Martínez, María Rodríguez and Manica, Matteo},
    title = {Chemical representation learning for toxicity prediction},
    journal = {Digital Discovery},
    year = {2023},
    pages = {-},
    publisher = {RSC},
    doi = {10.1039/D2DD00099G},
    url = {http://dx.doi.org/10.1039/D2DD00099G}
}
```


### Unsupported properties
The following molecular properties are available via the GT4SD API but not in this UI:
- [MoleculeOne](https://tdcommons.ai/functions/oracles/#moleculeone) endpoint for retrosynthesis
- [ASKCOS](https://tdcommons.ai/functions/oracles/#askcos) endpoint for retrosynthesis
- [TDC-Docking](https://tdcommons.ai/functions/oracles/#docking-scores) endpoint for docking against a user-provided target
- [TDC-Docking](https://tdcommons.ai/functions/oracles/#docking-scores) endpoint for docking against *3pbl*.
- [Protein-ligand binding](https://tdcommons.ai/functions/oracles/#dopamine-receptor-d2-drd2) against one of the targets *drd2*, *gsk3b*, *jnk3*, *fpscores*, *cyp3a4_veith*, *drd2_current*, *gsk3b_current* or *jnk3_current*.
- [Tanimoto similarity](https://tdcommons.ai/functions/oracles/#similaritydissimilarity) to a seed molecule.


Moreover, GT4SD also includes properties on other entities such as [proteins](https://gt4sd.github.io/gt4sd-core/api/gt4sd.properties.proteins.html) and [crystals](https://gt4sd.github.io/gt4sd-core/api/gt4sd.properties.crystals.html).
The GT4SD web app for proteins can be found [here](https://huggingface.co/spaces/GT4SD/protein_properties)


