import requests
from PIL import Image
from io import BytesIO
from numpy import asarray
import gradio as gr
import numpy as np
from math import ceil
from huggingface_hub import from_pretrained_keras

api_key = 'https://api.nasa.gov/planetary/apod?api_key=0eyGPKWmJmE5Z0Ijx25oG56ydbTKWE2H75xuEefx'
date = '&date=2022-12-20'
def getRequest(date):
    r = requests.get(api_key + date)
    result = r.json()
    receive = requests.get(result['url'])
    img = Image.open(BytesIO(receive.content)).convert('RGB')
    return img


model = from_pretrained_keras("GIanlucaRub/doubleResFinal")
# model = from_pretrained_keras("GIanlucaRub/autoencoder_model_d_0")

def double_res(input_image):
    input_height = input_image.shape[0]
    input_width = input_image.shape[1]
    height = ceil(input_height/128)
    width = ceil(input_width/128)
    expanded_input_image = np.zeros((128*height, 128*width, 3), dtype=np.uint8)
    np.copyto(expanded_input_image[0:input_height, 0:input_width], input_image)

    output_image = np.zeros((128*height*2, 128*width*2, 3), dtype=np.float32)
    
    to_predict = []
    for i in range(height):
        for j in range(width):
            temp_slice = expanded_input_image[i *
                                              128:(i+1)*128, j*128:(j+1)*128]/255
            to_predict.append(temp_slice)

# removing inner borders

    for i in range(height):
        for j in range(width):        
            if i != 0 and j != 0 and i != height-1 and j != width-1:
                right_slice = expanded_input_image[i *
                                                   128:(i+1)*128, (j+1)*128-64:(j+1)*128+64]/255
                to_predict.append(right_slice)
    

                left_slice = expanded_input_image[i *
                                                  128:(i+1)*128, j*128-64:(j)*128+64]/255
                to_predict.append(left_slice)
    

                upper_slice = expanded_input_image[(
                    i+1)*128-64:(i+1)*128+64, j*128:(j+1)*128]/255
                to_predict.append(upper_slice)
                

                lower_slice = expanded_input_image[i *
                                                   128-64:i*128+64, j*128:(j+1)*128]/255
                to_predict.append(lower_slice)
    # removing angles

                lower_right_slice = expanded_input_image[i *
                                                         128-64:i*128+64, (j+1)*128-64:(j+1)*128+64]/255
                to_predict.append(lower_right_slice)

                lower_left_slice = expanded_input_image[i *
                                                        128-64:i*128+64, j*128-64:j*128+64]/255
                to_predict.append(lower_left_slice)
                
# predicting all images at once
    completed = False
    n = 16
    # n = 1
    while not completed:
        try:
            print("attempting with "+ str(n))
            predicted = model.predict(np.array(to_predict),batch_size = n)
            completed = True
            print("completed with "+ str(n))
        except:
            print("attempt with " + str(n) + " failed")
            n += -1
            if n <= 0:
                n = 1
    counter = 0
    for i in range(height):
        for j in range(width):
            np.copyto(output_image[i*256:(i+1)*256, j *
                      256:(j+1)*256], predicted[counter])
            counter+=1
    
                

    for i in range(height):
        for j in range(width):        
            if i != 0 and j != 0 and i != height-1 and j != width-1:            
                right_upsampled_slice = predicted[counter]
                counter+=1
                resized_right_slice = right_upsampled_slice[64:192, 64:192]
                np.copyto(output_image[i*256+64:(i+1)*256-64,
                          (j+1)*256-64:(j+1)*256+64], resized_right_slice)
    
                
    

                left_upsampled_slice = predicted[counter]
                counter+=1
                resized_left_slice = left_upsampled_slice[64:192, 64:192]
                np.copyto(output_image[i*256+64:(i+1)*256-64,
                          j*256-64:j*256+64], resized_left_slice)
                
    

                upper_upsampled_slice = predicted[counter]
                counter+=1
                resized_upper_slice = upper_upsampled_slice[64:192, 64:192]
                np.copyto(output_image[(i+1)*256-64:(i+1)*256+64,
                          j*256+64:(j+1)*256-64], resized_upper_slice)
                
    

                lower_upsampled_slice = predicted[counter]
                counter+=1
                resized_lower_slice = lower_upsampled_slice[64:192, 64:192]
                np.copyto(output_image[i*256-64:i*256+64,
                          j*256+64:(j+1)*256-64], resized_lower_slice)



                lower_right_upsampled_slice = predicted[counter]
                counter+=1
                resized_lower_right_slice = lower_right_upsampled_slice[64:192, 64:192]        
                np.copyto(output_image[i*256-64:i*256+64,  (j+1)
                          * 256-64:(j+1)*256+64], resized_lower_right_slice)


                lower_left_upsampled_slice = predicted[counter]
                counter+=1
                resized_lower_left_slice = lower_left_upsampled_slice[64:192, 64:192]
                np.copyto(
                    output_image[i*256-64:i*256+64,  j*256-64:j*256+64], resized_lower_left_slice)

    resized_output_image = output_image[0:input_height*2, 0:input_width*2]
    return resized_output_image

def get_new_img():
    # sometimes the new image is a video
    try:
        original_img = getRequest('')
    except:
        original_img = getRequest(date)
    numpydata = asarray(original_img)
    doubled_img = double_res(numpydata)  # numpy.ndarray
    return original_img,doubled_img

original_img, doubled_img = get_new_img()

with gr.Blocks() as demo:
    with gr.Row():
        with gr.Column():
            gr.Label("Original image")
            original = gr.Image(original_img)
        with gr.Column():
            gr.Label("Image with doubled resolution")
            doubled = gr.Image(doubled_img)
    with gr.Row():
        btn_get = gr.Button("Get the new daily image")
    # Event
    btn_get.click(get_new_img, inputs=None, outputs = [original,doubled])
demo.launch()