import gradio as gr
from transformers import pipeline

pipe = pipeline("text-classification", model="jonas/sdg_classifier_osdg")

sdg_dict = {
'1':"SDG 1: End poverty in all its forms everywhere",
'2':"SDG 2: End hunger, achieve food security and improved nutrition and promote sustainable agriculture",
'3':"SDG3: Ensure healthy lives and promote well-being for all at all ages",
'4':"SDG 4: Ensure inclusive and equitable quality education and promote lifelong learning opportunities for all",
'5':"SDG 5: Achieve gender equality and empower all women and girls",
'6':"SDG 6: Ensure availability and sustainable management of water and sanitation for all",
'7':"SDG 7: Ensure access to affordable, reliable, sustainable and modern energy for all",
'8':"SDG 8: Promote sustained, inclusive and sustainable economic growth, full and productive employment and decent work for all",
'9':"SDG 9: Build resilient infrastructure, promote inclusive and sustainable industrialization and foster innovation",
'10':"SDG 10: Reduce inequality within and among countries",
'11':"SDG 11: Make cities and human settlements inclusive, safe, resilient and sustainable",
'12':"SDG 12: Ensure sustainable consumption and production patterns",
'13':"SDG 13: Take urgent action to combat climate change and its impacts*",
'14':"SDG 14: Conserve and sustainably use the oceans, seas and marine resources for sustainable development",
'15':"SDG 15: Protect, restore and promote sustainable use of terrestrial ecosystems, sustainably manage forests, combat desertification, and halt and reverse land degradation and halt biodiversity loss"
}

def predict(text):
    preds = pipe(text)[0]
    return sdg_dict[preds["label"]], str(round(preds["score"], 5)*100) + " %"

gradio_ui = gr.Interface(
    fn=predict,
    title="Predict Sustainable Development Goals Labels",
    description="This Space showcases a Machine Learning model for classifying text according to the first 15 of the 17 Sustainable Development Goals from the United Nations. Note that model is trained on quite short paragraphs (around 100 words) and performs best with similar input sizes.Training data comes from the amazing https://osdg.ai/ community!.",
    inputs=[
        gr.inputs.Textbox(lines=5, label="Paste some text here"),
    ],
    outputs=[
        gr.outputs.Textbox(label="SDG Label"),
        gr.outputs.Textbox(label="Certainty"),
    ],
    examples=[
        ["The Paris Agreement, adopted in 2015, aims to strengthen the global response to the threat of climate change by keeping a global temperature rise this century well below 2 degrees Celsius above pre-industrial levels. The agreement also aims to strengthen the ability of countries to deal with the impacts of climate change, through appropriate financial flows, a new technology framework and an enhanced capacity building framework."], 
        ["Gender equality is not only a fundamental human right, but a necessary foundation for a peaceful, prosperous and sustainable world. There has been progress over the last decades: More girls are going to school, fewer girls are forced into early marriage, more women are serving in parliament and positions of leadership, and laws are being reformed to advance gender equality."]
    ],
)

gradio_ui.launch(debug=True)