
import streamlit as st
from PIL import Image
import tempfile
import logging
logger = logging.getLogger(__name__)

# Initialization
#if 'file' not in st.session_state:
#    st.session_state['embed_list'] = ["first"]
    

class MultiApp:
    """
    Framework for combining multiple streamlit applications.
    """
    def __init__(self):
        self.apps = []
        if 'embed_list' not in st.session_state:
            st.session_state['embed_list'] = ["first"]
        if 'cat_list' not in st.session_state:
            st.session_state['cat_list'] = ["first"]

    def add_app(self, title, func):
        """Adds a new application.
        Parameters
        ----------
        func:
            the python function to render this app.
        title:
            title of the app. Appears in the dropdown in the sidebar.
        """
        self.apps.append({
            "title": title,
           # "icon": icon,
            "function": func
        })

    def run(self):
    
        st.sidebar.write(format_func=lambda app: app['title'])
        #image = Image.open('appStore/img/sdsn.png')
        #st.sidebar.image(image)
        st.sidebar.markdown("##  📌 Pages ")
        app = st.sidebar.radio(
            'Pages',
            self.apps,
            format_func=lambda app: app['title'])    
        app['function']()
        st.sidebar.markdown('')
        
        
