from googleapiclient.discovery import build
from dotenv import load_dotenv
import os
from urllib.parse import urlparse
from urllib.parse import parse_qs

def get_top5_comments(url):
    v_id = video_id(url)
    load_dotenv()
    api_key = os.getenv('api_key')
    youtube = build('youtube', 'v3', developerKey=api_key)
    try:
        comments_response = youtube.commentThreads().list(
                part='snippet',
                videoId=v_id,
                textFormat='plainText',
                maxResults=5,
                order='relevance').execute()
            
        top_five = []
        for comment in comments_response['items']:
            comment_text = comment['snippet']['topLevelComment']['snippet']['textDisplay']
            top_five.append(comment_text)
        return top_five
    except:
        return None
    

def video_id(value):
    """
    Examples:
    - http://youtu.be/SA2iWivDJiE
    - http://www.youtube.com/watch?v=_oPAwA_Udwc&feature=feedu
    - http://www.youtube.com/embed/SA2iWivDJiE
    - http://www.youtube.com/v/SA2iWivDJiE?version=3&amp;hl=en_US
    """
    query = urlparse(value)
    if query.hostname == 'youtu.be':
        return query.path[1:]
    if query.hostname in ('www.youtube.com', 'youtube.com'):
        if query.path == '/watch':
            p = parse_qs(query.query)
            return p['v'][0]
        if query.path[:7] == '/embed/':
            return query.path.split('/')[2]
        if query.path[:3] == '/v/':
            return query.path.split('/')[2]
    # fail?
    return None
