import re
import string
import numpy as np
from nltk.corpus import stopwords
from nltk.stem import PorterStemmer
from nltk.tokenize import TweetTokenizer

class util:

    def process_tweet(self, tweet):

    # Process tweet function.
    # Input:
    # tweet: a string containing a tweet
    # Output:
    # tweets_clean: a list of words containing the processed tweet

        stemmer = PorterStemmer()
        stopwords_english = stopwords.words('english')
        # remove stock market tickers like $GE
        tweet = re.sub(r'\$\w*', '', tweet)
        # remove old style retweet text "RT"
        tweet = re.sub(r'^RT[\s]+', '', tweet)
        # remove hyperlinks    
        tweet = re.sub(r'https?://[^\s\n\r]+', '', tweet)
        # remove hashtags
        # only removing the hash # sign from the word
        tweet = re.sub(r'#', '', tweet)
        # tokenize tweets
        tokenizer = TweetTokenizer(preserve_case=False, strip_handles=True,
                                reduce_len=True)
        tweet_tokens = tokenizer.tokenize(tweet)

        tweets_clean = []
        for word in tweet_tokens:
            if (word not in stopwords_english and  # remove stopwords
                    word not in string.punctuation):  # remove punctuation
                # tweets_clean.append(word)
                stem_word = stemmer.stem(word)  # stemming word
                tweets_clean.append(stem_word)

        return tweets_clean
    
    def extract_features(self,tweet, freqs):
        '''
        Input: 
            tweet: a list of words for one tweet
            freqs: a dictionary corresponding to the frequencies of each tuple (word, label)
        Output: 
            x: a feature vector of dimension (1,3)
        '''
        # process_tweet tokenizes, stems, and removes stopwords
        word_l = self.process_tweet(tweet)
        
        # 3 elements for [bias, positive, negative] counts
        x = np.zeros(3) 
        
        # bias term is set to 1
        x[0] = 1 
        
        ### START CODE HERE ###
        # loop through each word in the list of words
        for word in word_l:
            # increment the word count for the positive label 1
            if (word,1) in freqs.keys():
                x[1] += freqs[(word,1)]
            
            # increment the word count for the negative label 0
            if (word,0) in freqs.keys():
                x[2] += freqs[(word,0)]
            
        ### END CODE HERE ###
        
        x = x[None, :]  # adding batch dimension for further processing
        assert(x.shape == (1, 3))
        return x
    
    def sigmoid(self,z): 
        '''
        Input:
            z: is the input (can be a scalar or an array)
        Output:
            h: the sigmoid of z
        '''
        
        ### START CODE HERE ###
        # calculate the sigmoid of z
        h = 1/(1+np.exp(-z))
        ### END CODE HERE ###
        
        return h
    
    def nb_predict(self,comment,logprior,loglikelihood):
        word_l = self.process_tweet(comment)

        # initialize probability to zero
        p = 0

        # add the logprior
        p += logprior

        for word in word_l:

            # check if the word exists in the loglikelihood dictionary
            if word in loglikelihood:
                # add the log likelihood of that word to the probability
                p += loglikelihood[word]

        return p