import pickle
from utils import util
from youtube_comment_tool import get_top5_comments
import numpy as np 
import pandas as pd
import gradio as gr
import nltk
nltk.download('stopwords')

with open('freqs_dict.pickle', 'rb') as handle:
    freqs = pickle.load(handle)

with open('theta.pickle', 'rb') as handle:
    theta = pickle.load(handle)

with open('loglikelihood.pickle', 'rb') as handle:
    loglikelihood = pickle.load(handle)

with open('logprior.pickle', 'rb') as handle:
    logprior = pickle.load(handle)

def get_avg_sentiment(url,model_choice):
    s = get_top5_comments(url)
    if s:
        helper = util()
        ss = []
        if model_choice == "Basic NN":
            for comment in s:
                x = helper.extract_features(comment,freqs)
                ss.append(helper.sigmoid(np.dot(x,theta))[0][0])
            
        elif model_choice == "Naive Bayes":
            for comment in s:
                x = helper.nb_predict(comment,logprior,loglikelihood)
                ss.append(x)
                print(comment,x)
        df = pd.DataFrame()
        df['Comments'] = s
        df['Sentiment'] = ss
        return df
    else:
        return 'Video URL was not Found.'
    
with gr.Blocks() as demo:
    with gr.Row():
        model_choice = gr.Dropdown(['Basic NN','Naive Bayes'], label="Choose Sentiment Model")
        url_box = gr.Textbox(label="Youtube URL")
        submit_btn = gr.Button("Search")
    with gr.Row():
        DataFrameBox = gr.DataFrame(type="pandas",col_count=(2, "fixed"),wrap=True)
    
    submit_btn.click(
        get_avg_sentiment,
        [url_box,model_choice],
        [DataFrameBox]
    )

demo.launch()