from typing import Dict, List

from pydantic import BaseModel


class Task(BaseModel):
    values: List[str]
    keys: List[str]


class GEMSchema(BaseModel):
    """The default GEM schema"""

    submission_name: str
    param_count: int
    description: str = "An optional brief description of the system that will be shown on the results page"
    tasks: Dict[str, Task]


def main():
    schema_data = GEMSchema.schema_json(indent=2)
    with open("schema.json", "w", encoding="utf-8") as f:
        f.write(schema_data)


if __name__ == "__main__":
    main()
