# Formatting Utilities

The resources in this folder are used to format the saved dataset card in a readable format (JSON, Markdown).

File | Description
--- | ---
[`key_to_question.json`](https://huggingface.co/spaces/GEM/DatasetCardForm/blob/main/formatting/key_to_question.json) | Maps from the saved key back to the original question, which can then be parsed into question/answer pairs.
[`reformat_json.py`](https://huggingface.co/spaces/GEM/DatasetCardForm/blob/main/formatting/reformat_json.py) | Uses `key_to_question.json` to transform dataset cards into a JSON organized by Data Card standards (e.g., sections, subsections, scopes). Everything labeled `N/A` in the original card will be rendered; empty fields will be completely omitted.
[`json_to_md.py`](https://huggingface.co/spaces/GEM/DatasetCardForm/blob/main/formatting/json_to_md.py) | Transforms output from `reformat_json.py` into Markdown that is compatible with Data Cards Labs (e.g., special comment syntax).