import streamlit as st
from textblob import TextBlob

st.write("This is a basic sentiment analysis demo using textblob. It will take your input and assign a polarity score between -1.0 (negative sentiment) and +1.0 (positive sentiment). Subjectivity is given a score between 0.0 and 1.0 where 0.0 is very objective and 1.0 is very subjective. Textblob has the advantage of being relatively decent at sentiment analysis while fast and cheap compared to modern techniques. ")

x = st.text_input('Enter some text to be analyzed:')



if st.button('Analyze your input'):
  testimonial = TextBlob( x )
  polarity_score = testimonial.sentiment.polarity
  subjectivity_score = testimonial.sentiment.subjectivity
  
  st.write("Sentiment polarity: ", str(polarity_score) , "   Subjectivity: ", str(subjectivity_score) )
