# Import Libraries.
import pandas as pd
import streamlit as st
import datetime

# Read Data from Excel Workbook.
dataset = pd.read_excel('ScreenOutput.xlsx')

# Create Page Title in Browser.
st.set_page_config(page_title='Alpha Stocks Screener', layout = 'wide') 

# Create Sidebar Header.
st.sidebar.header('Alpha Stocks:')

# Create Filter for Stocks.
with st.sidebar:
    container = st.container()
    all = st.checkbox("Select all")

    if all:
        selected_options = container.multiselect("Select one or more stocks:", options=dataset['Stock'].unique(), default=dataset['Stock'].unique())
    else:
        selected_options =  container.multiselect("Select one or more stocks:", options=dataset['Stock'].unique())
    
# Create Title for Dashboard.
st.title('Alpha Stocks Screener Dashboard')

# Calculate Total Number of Alpha Stocks.
selection_query=dataset.query('Stock==@selected_options')
total_number_of_stocks = len(selection_query.index)

# Retrieve Today Date.
current_datetime=datetime.datetime.now()

# Create Description for Dashboard.
col1, col2, col3 = st.columns(3)
col1.metric("Today", current_datetime.strftime("%d %B %Y"))
col2.metric("Optionable", "Yes")
col3.metric("Number of Alpha Stocks", f'{total_number_of_stocks}')

tab1, tab2, tab3 = st.tabs(["Alpha Stocks", "Trades", "Summary"])

with tab1:
    st.header("List of Alpha Stocks")
    # Display List of Alpha Stocks in Table.
    st.dataframe(selection_query)

    # Download a Large DataFrame as a CSV.
    @st.cache
    
    def convert_df(df):
    # IMPORTANT: Cache the conversion to prevent computation on every rerun
        return df.to_csv().encode('utf-8')

    csv = convert_df(selection_query)

    st.download_button(label="Download data as CSV", data=csv, file_name='alpha_stocks.csv', mime='text/csv',)

with tab2:
    st.header("List of Trades")
   
with tab3:
    st.header("Trades Summary")

