import gradio as gr
from transformers import pipeline

pipeline = pipeline(task="image-classification", model="Fu-chiang/bit-50-skin-lesions")

def predict(image):
    predictions = pipeline(image)
    return {p["label"]: p["score"] for p in predictions}

gr.Interface(
    predict,
    inputs=gr.inputs.Image(label="Upload skin lesion picture", type="filepath"),
    outputs=gr.outputs.Label(num_top_classes=2),
    title="Melanoma or Nevus?",
).launch()
