import numpy as np
import torch
from huggan.pytorch.lightweight_gan.lightweight_gan import LightweightGAN 

def cargar_mdoel(model_name = "ceyda/butterfly_cropped_uniq1K_512", model_version = None):
    gan = LightweightGAN.from_pretrained(model_name, version = model_version)
    gan.eval()
    return gan

def general(gan, bach_size=1):
    with torch.no_grad():
        ims = gan.G(torch.rand(bach_size, gan.latent_dim)).clamp_(0.0,1.0) * 255
        ims = ims.permute(0,2,3,1).detach().cpu().numpy().astype(np.uint8)
    return ims
    