from matplotlib import pyplot as plt
from spacy.lang.es.stop_words import STOP_WORDS as es_stopwords
from wordcloud import WordCloud

def plots_world_cloud(df, title, figsize=(10, 10)):
    """This function is used to plot the world cloud"""
    text = " ".join(df)
    plt.figure(figsize=figsize)
    wordcloud = WordCloud(background_color="white", stopwords=es_stopwords).generate(text)
    plt.imshow(wordcloud, interpolation='bilinear')
    plt.axis("off")
    plt.title(title)
    plt.show()