import gradio as gr
import cv2
from PIL import Image
import numpy as np

def upscale_image(input_image, scale_factor):
    image = Image.fromarray(input_image)

    width, height = image.size
    new_width = int(width * scale_factor)
    new_height = int(height * scale_factor)

    resized_image = image.resize((new_width, new_height), Image.Resampling.LANCZOS)
    cv_image = cv2.cvtColor(np.array(resized_image), cv2.COLOR_RGB2BGR)
    denoised_image = cv2.fastNlMeansDenoisingColored(cv_image, None, 10, 10, 7, 21)
    denoised_pil_image = Image.fromarray(cv2.cvtColor(denoised_image, cv2.COLOR_BGR2RGB))
    return denoised_pil_image

def upscale_image_interface(input_image, scale_factor):
    input_image_np = np.array(input_image)
    output_image = upscale_image(input_image_np, scale_factor)
    return output_image

image_input = gr.inputs.Image(label="Input Image", type="pil")
scale_factor_input = gr.inputs.Number(label="Scale Factor", default=2)
output = gr.outputs.Image(label="Output Image", type="pil")

title = "Image Upscaler"
description = "Upscale an image using a scale factor."
gr_interface = gr.Interface(fn=upscale_image_interface, inputs=[image_input, scale_factor_input], outputs=output, title=title, description=description)

if __name__ == "__main__":
    gr_interface.launch()
