#!/bin/bash
run() {
    echo -e "\033[32m已完成初始化，启动服务...\033[0m"
    python3 /app/vits-uma-genshin-honkai/app.py
}
install() {
    echo -e "\033[33m正在初始化：安装依赖....\033[0m"
    pip install -r /app/vits-uma-genshin-honkai/requirements.txt -i https://mirrors.ustc.edu.cn/pypi/web/simple
    echo -e "\033[33m正在下载模型....\033[0m"
    rm -f /app/vits-uma-genshin-honkai/model/G_953000.pth
    wget -O /app/vits-uma-genshin-honkai/model/G_953000.pth https://huggingface.co/spaces/ikechan8370/vits-uma-genshin-honkai/resolve/main/model/G_953000.pth
    echo -e "\033[32m初始化完成！\033[0m"
    run
}

if [ ! -f "/app/vits-uma-genshin-honkai/model/G_953000.pth" ] || [ "$(stat -c%s "/app/vits-uma-genshin-honkai/model/G_953000.pth")" -lt 10000 ]; then
    install
else
    run
fi
