import torch
from peft import PeftModel, PeftConfig
from transformers import AutoModelForCausalLM, AutoTokenizer

peft_model_id = f"c-s-ale/AI-Superstar-Model"
config = PeftConfig.from_pretrained(peft_model_id)
model = AutoModelForCausalLM.from_pretrained(
    config.base_model_name_or_path,
    return_dict=True,
    load_in_8bit=True,
    device_map="auto",
)
tokenizer = AutoTokenizer.from_pretrained(config.base_model_name_or_path)

# Load the Lora model
model = PeftModel.from_pretrained(model, peft_model_id)

def make_inference(question):
    batch = tokenizer(
        f"Please answer the following question to the best of your ability.\n\n### Question:\n{question}\n### Answer:\n",
        return_tensors="pt",
    )

    with torch.cuda.amp.autocast():
        output_tokens = model.generate(**batch, max_new_tokens=70)

    return tokenizer.decode(output_tokens[0], skip_special_tokens=True).split("\n\n")[-1]


if __name__ == "__main__":
    # make a gradio interface
    import gradio as gr

    gr.Interface(
        make_inference,
        [
            gr.inputs.Textbox(lines=2, label="Question"),
        ],
        gr.outputs.Textbox(label="Answer"),
        title="AI Super Star",
        description="AI Super Star is a tool you can use to guide you on your ML journey.",
    ).launch()