import gradio

class Model:
    def __init__(self, name, path="", prefix=""):
        self.name = name
        self.path = path
        self.prefix = prefix

models = [
    Model("Anime","models/DucHaiten/DucHaitenAnime","DucHaiten style"),
    Model("dreamlike","models/dreamlike-art/dreamlike-diffusion-1.0","dreamlike style"),
    #Model("Illuminati_Diffusion","models/IlluminatiAI/Illuminati_Diffusion_v1.0","photo realistic style"),
    Model("CF25","models/gsdf/Counterfeit-V2.5","best quality"),    
    Model("Midjourney","models/prompthero/midjourney-v4-diffusion","midjourney style"),
    Model("PhotoReal","models/dreamlike-art/dreamlike-photoreal-2.0","photoreal style"),
    Model("MF Base","models/MyneFactory/MF-Base","booru style"),
    Model("Anything","models/Linaqruf/anything-v3.0", "Anything style")
]

model1=[]
model2=[]
model3=[]

for i in range(len(models)):
    model3.append(models[i].name)
    model1.append(gradio.Interface.load(models[i].path))
    model2.append(models[i].prefix)

def ProcessP(prompt, modelSelected):
    print(prompt)
    print(modelSelected)
    if (modelSelected==''):
        modelSelected = "Anything"
    model_idx=model3.index(modelSelected)
    prompt+=", in "+model2[model_idx]
    image_return = model1[model_idx](prompt)
    return image_return

sandbox = gradio.Interface(fn=ProcessP, 
                        inputs=[gradio.Textbox(label="Enter Prompt:"),  gradio.Dropdown(model3)],
                        outputs=[gradio.Image(label="Produced Image")], 
                        title='AlStable Text to Image')
sandbox.queue(concurrency_count=20).launch(debug=True)