import streamlit as st
from templates.Templates import PromptTemplate
from generators.title_to_abstract import title_to_abstract_generator
from generators.topic_to_abstract import topic_to_abstract_generator

from flask_app import generate


prompt = PromptTemplate()

result_text = ""

st.title('Scientific Paper Abstract Writer')


col_1, col_2 = st.columns(2)

with col_1:
    st.markdown(
        """
        This is an **AI powered** tool that will help you write an abstract for your scientific paper.

        There are two ways you can generate the abstract:

        1. **Title to Abstract** - This will generate an abstract based on the title of your paper.

        2. **Topic to Abstract** - This will generate an abstract based on the topic of your paper.
        """
    )
with col_2:
    option = st.radio('Please select one',
                      ('Title to Abstract', 'Topic to Abstract'))

    st.write('You selected:', option)

    if option == 'Title to Abstract':
        title = st.text_area(
            'Please input the title of the paper. '
            'Five or more words are suggested for best results. ')
        if st.button('Generate'):
            with st.spinner('Generating...'):
                result = generate({'title': title}, 'title')
                st.success('Generated abstract: ')
                result_text = result['result']
    else:
        topic = st.text_area(
            'Please input the topic of the paper. Example: Topic_1 , Topic_2, Topic_3 ')
        list_topic = topic.split(',')
        if st.button('Generate'):
            with st.spinner('Generating...'):
                result = generate({'topic': list_topic}, 'topic')
                st.success('Generated abstract: ')
                result_text = result['result']

st.write(result_text)


st.markdown("![visitor badge](https://visitor-badge.glitch.me/badge?page_id=Ghostwriter-Bloom)")