async () => {
	async function uploadFile(file){
		const UPLOAD_URL = 'https://huggingface.co/uploads';
		const response = await fetch(UPLOAD_URL, {
			method: 'POST',
			headers: {
				'Content-Type': file.type,
				'X-Requested-With': 'XMLHttpRequest',
			},
			body: file, /// <- File inherits from Blob
		});
		const url = await response.text();
		return url;
	}

	async function getInputImgFile(imgEl){
        const res = await fetch(imgEl.src);
        const blob = await res.blob();
        const imgId = Date.now() % 200;
        const isPng = imgEl.src.startsWith(`data:image/png`);
        if(isPng){
            const fileName = `sd-perception-${{imgId}}.png`;
            return new File([blob], fileName, { type: 'image/png' });
        }else{
            const fileName = `sd-perception-${{imgId}}.jpg`;
            return new File([blob], fileName, { type: 'image/jpeg' });
        }
	}

    // const gradioEl = document.querySelector('body > gradio-app');
    const gradioEl = document.querySelector("gradio-app");
    const inputTxt = gradioEl.querySelector('#q-input textarea').value;
    let outputTxt = gradioEl.querySelector('#q-output .codemirror-wrapper .cm-scroller > div:nth-of-type(2)').innerText;
    outputTxt = `<pre>${outputTxt}</pre>`

    const titleLength = 150;
    let titleTxt = inputTxt;
    if(titleTxt.length > titleLength){
        titleTxt = titleTxt.slice(0, titleLength) + ' ...';
    }

    const shareBtnEl = gradioEl.querySelector('#share-btn');
    const shareIconEl = gradioEl.querySelector('#share-btn-share-icon');
    const loadingIconEl = gradioEl.querySelector('#share-btn-loading-icon');

    if(!inputTxt || !outputTxt){
        return;
    };

    shareBtnEl.style.pointerEvents = 'none';
    shareIconEl.style.display = 'none';
    loadingIconEl.style.removeProperty('display');

	const descriptionMd = `### Question:
${inputTxt}

### Answer:

${outputTxt}`;

    const params = {
        title: titleTxt,
        description: descriptionMd,
    };

    const paramsStr = Object.entries(params)
        .map(([key, value]) => `${encodeURIComponent(key)}=${encodeURIComponent(value)}`)
        .join('&');

	window.open(`https://huggingface.co/spaces/fisharp/starcoder-playground/discussions/new?${paramsStr}`, '_blank');

    shareBtnEl.style.removeProperty('pointer-events');
    shareIconEl.style.removeProperty('display');
    loadingIconEl.style.display = 'none';
}
