import os
import tiktoken

import gradio as gr
import openai

openai.api_key = os.environ['OPENAI_API_KEY']

# Tokenizer (Used solely for counting tokens here)
enc = tiktoken.encoding_for_model("text-davinci-003")

def token_count(text):
    num_tokens = len(enc.encode(text))
    return f"There are {num_tokens} tokens."

def moderation(text):
    response = openai.Moderation.create(input=text)
    output = response["results"][0]
    return output

def main(text):
    return moderation(text), token_count(text)

iface = gr.Interface(
    fn=main,
    inputs=gr.inputs.Textbox(lines=10, label="Text"),
    outputs=["text","text"],
    title="OpenAI Moderation API",
    description="This is a demo of the OpenAI Moderation API. Enter text in the box below and click submit to see the output.",
    allow_flagging=False,
    layout="vertical",
    theme="huggingface",
)


iface.launch()