import torch
import torch.nn.functional as F
from torch import optim
from torch.nn import Module
from torchvision import models, transforms
from torchvision.datasets import ImageFolder
from PIL import Image
import numpy as np
import gradio as gr
import os


data_transforms = {
    'train': transforms.Compose([
        transforms.RandomResizedCrop(224),
        transforms.RandomHorizontalFlip(),
        transforms.ToTensor(),
        transforms.Normalize([0.485, 0.456, 0.406], [0.229, 0.224, 0.225])
    ]),
    'val': transforms.Compose([
        transforms.Resize(256),
        transforms.CenterCrop(224),
        transforms.ToTensor(),
        transforms.Normalize([0.485, 0.456, 0.406], [0.229, 0.224, 0.225])
    ]),
}
os.environ["CUDA_VISIBLE_DEVICES"]="0"
device = torch.device("cuda:0" if torch.cuda.is_available() else "cpu")
class_names = {0: 'Agaricus arvensis Schaeff.', 1: 'Agaricus augustus Fr.', 2: 'Agaricus bernardii (Quél.) Sacc.', 
               3: 'Agaricus bisporus (J.E.Lange) Pilat', 4: 'Agaricus bitorquis (Quél.) Sacc.', 5: 'Agaricus bohusii Bon', 
               6: 'Agaricus brunneolus (J.E.Lange) Pilát', 7: 'Agaricus campestris L.', 8: 'Agaricus crocodilinus Murrill', 
               9: 'Agaricus cupreobrunneus (Jul.Schäff. & Steer) Pilát', 10: 'Agaricus dulcidulus Schulzer', 11: 'Agaricus essettei Bon', 
               12: 'Agaricus impudicus (Rea) Pilát', 13: 'Agaricus langei (F.H.Møller & Jul.Schäff.) Maire', 
               14: 'Agaricus lanipes (F.H.Møller & Jul.Schäff.) Singer', 15: 'Agaricus litoralis (Wakef. & A.Pearson) Pilát', 
               16: 'Agaricus moelleri Wasser', 17: 'Agaricus subfloccosus (J.E.Lange) Pilát', 
               18: 'Agaricus subperonatus (J.E.Lange) Singer', 19: 'Agaricus sylvaticus Schaeff.', 
               20: 'Agaricus sylvicola (Vittad.) Peck, 1872', 21: 'Agaricus xanthodermus Genev.', 
               22: 'Amanita ceciliae (Berk. & Broome) Bas', 23: 'Amanita citrina Pers., 1797', 24: 'Amanita crocea (Quél.) Singer', 
               25: 'Amanita excelsa Gonn. & Rabenh.', 26: 'Amanita franchetii (Boud.) Fayod', 27: 'Amanita fulva (Schaeff.) Fr.', 
               28: 'Amanita gemmata (Fr.) Bertill.', 29: 'Amanita lividopallescens (Secr. ex Boud.) Kühner & Romagn.', 
               30: 'Amanita muscaria (L.) Lam., 1783', 31: 'Amanita pantherina (DC.) Krombh.', 32: 'Amanita phalloides (Vaill. ex Fr.) Link', 
               33: 'Amanita porphyria Alb. & Schwein.', 34: 'Amanita rubescens (Pers.) Gray', 35: 'Amanita strobiliformis Gonn. & Rabenh.', 
               36: 'Amanita submembranacea (Bon) Gröger', 37: 'Amanita vaginata (Bull.) Vittad.', 38: 'Amanita virosa (Fr.) Bertill.', 
               39: 'Boletus aereus Secr.', 40: 'Boletus edulis Bull.', 41: 'Boletus pinophilus Pilát & Dermek', 
               42: 'Boletus reticulatus Schaeff.', 43: 'Clitocybe agrestis Harmaja', 44: 'Clitocybe diatreta (Fr.) P.Kumm.', 
               45: 'Clitocybe fragrans Sowerby', 46: 'Clitocybe metachroa (Fr.) P.Kumm.', 47: 'Clitocybe nebularis (Batsch) Quél.', 
               48: 'Clitocybe nitrophila Bon', 49: 'Clitocybe odora (Bull.) P.Kumm.', 50: 'Clitocybe phyllophila (Pers.) P.Kumm.', 
               51: 'Clitocybe rivulosa (Pers.) P.Kumm.', 52: 'Clitocybe vibecina (Fr.) Quél.', 
               53: 'Infundibulicybe costata (Kühner & Romagn.) Harmaja', 54: 'Infundibulicybe gibba (Pers.) Harmaja', 
               55: 'Infundibulicybe squamulosa (Pers.) Harmaja', 56: 'Mycena abramsii (Murrill) Murrill', 
               57: 'Mycena acicula (Schaeff.) P.Kumm.', 58: 'Mycena aetites (Fr.) Quél.', 59: 'Mycena amicta (Fr.) Quél.', 
               60: 'Mycena arcangeliana Bres.', 61: 'Mycena aurantiomarginata (Fr.) Quél.', 62: 'Mycena belliae (Johnst.) P.D.Orton', 
               63: 'Mycena capillaripes Peck', 64: 'Mycena capillaris P.Karst.', 65: 'Mycena chlorantha (Fr.) P.Kumm.', 
               66: 'Mycena cinerella (P.Karst.) P.Karst.', 67: 'Mycena citrinomarginata Gillet', 68: 'Mycena clavicularis (Fr.) Gillet', 
               69: 'Mycena clavularis (Batsch) Sacc.', 70: 'Mycena crocata (Schrad.) P.Kumm.', 71: 'Mycena diosma Krieglst. & Schwöbel', 
               72: 'Mycena epipterygia (Scop.) Gray', 73: 'Mycena erubescens Höhn.', 74: 'Mycena filopes (Bull.) P.Kumm.', 
               75: 'Mycena flavescens Velen.', 76: 'Mycena galericulata (Scop.) Gray', 77: 'Mycena galopus (Pers.) P.Kumm., 1871', 
               78: 'Mycena haematopus (Pers.) P.Kumm.', 79: 'Mycena inclinata (Fr.) Quél.', 80: 'Mycena juniperina Aronsen', 
               81: 'Mycena leptocephala (Pers.) Gillet', 82: 'Mycena luteovariegata (Gillet) Harder & Laessøe, 2013', 
               83: 'Mycena megaspora Kauffman', 84: 'Mycena meliigena (Berk. & Cooke) Sacc.', 85: 'Mycena metata (Secr. ex Fr.) Quél.', 
               86: 'Mycena olivaceomarginata (Massee) Massee', 87: 'Mycena pelianthina (Fr.) Quél.', 88: 'Mycena polygramma (Bull.) Gray', 
               89: 'Mycena pseudocorticola Kühner', 90: 'Mycena pterigena (Fr.) P.Kumm.', 91: 'Mycena pura (Pers.) Sacc.', 
               92: 'Mycena purpureofusca (Peck) Sacc.', 93: 'Mycena renati Quél.', 94: 'Mycena rosea (Schumach.) Gramberg', 
               95: 'Mycena rosella (Fr.) P.Kumm.', 96: 'Mycena rubromarginata (Fr.) P.Kumm.', 
               97: 'Mycena sanguinolenta (Alb. & Schwein.) P.Kumm.', 98: 'Mycena silvae-nigrae Maas Geest. & Schwöbel', 
               99: 'Mycena stipata Maas Geest. & Schwöbel', 100: 'Mycena stylobates (Pers.) P.Kumm.', 
               101: 'Mycena tenerrima (Berk.) Sacc.', 102: 'Mycena tintinnabulum (Batsch) Quél.', 103: 'Mycena vitilis (Fr.) Quél.', 
               104: 'Mycena vulgaris (Pers.) P.Kumm.', 105: 'Russula acrifolia Romagn.', 106: 'Russula adusta (Pers.) Fr.', 
               107: 'Russula aeruginea Fr.', 108: 'Russula amoenolens Romagn.', 109: 'Russula atrorubens Quél.', 
               110: 'Russula aurea Pers.', 111: 'Russula betularum Hora', 112: 'Russula brunneoviolacea Crawshay', 
               113: 'Russula caerulea (Pers.) Fr.', 114: 'Russula cessans A.Pearson', 115: 'Russula chloroides (Krombh.) Bres.', 
               116: 'Russula claroflava Grove', 117: 'Russula cuprea (Krombh.) J.E.Lange', 118: 'Russula curtipes F.H.Møller & Jul.Schäff.', 
               119: 'Russula cyanoxantha (Schaeff.) Fr.', 120: 'Russula decolorans (Fr.) Fr.', 121: 'Russula delica Fr.', 
               122: 'Russula densifolia Secr. ex Gillet', 123: 'Russula depallens Fr.', 124: 'Russula emetica (Schaeff.) Pers.', 
               125: 'Russula faginea Romagn., 1967', 126: 'Russula farinipes Romell', 127: 'Russula faustiana Sarnari', 
               128: 'Russula fellea (Fr.) Fr.', 129: 'Russula foetens (Pers.) Fr.', 130: 'Russula fragilis Fr., 1838', 
               131: 'Russula grata Britzelm.', 132: 'Russula graveolens Romell', 133: 'Russula grisea (Batsch) Fr.', 
               134: 'Russula heterophylla (Fr.) Fr.', 135: 'Russula illota Romagn.', 136: 'Russula insignis Quél.', 
               137: 'Russula integra (L.) Fr., 1838', 138: 'Russula ionochlora Romagn.', 139: 'Russula laccata Huijsman', 
               140: 'Russula laeta Jul.Schäff.', 141: 'Russula lepida Fr.', 142: 'Russula luteotacta Rea', 
               143: 'Russula maculata Quél. & Roze', 144: 'Russula mairei Singer', 145: 'Russula melliolens Quél.', 
               146: 'Russula nauseosa (Pers.) Fr.', 147: 'Russula nigricans (Bull.) Fr.', 148: 'Russula nitida (Pers.) Fr.', 
               149: 'Russula ochroleuca (Pers.) Fr.', 150: 'Russula odorata Romagn.', 151: 'Russula olivacea (Schaeff.) Fr.', 
               152: 'Russula paludosa Britzelm.', 153: 'Russula parazurea Jul.Schäff.', 154: 'Russula pelargonia Niolle', 
               155: 'Russula praetervisa Sarnari', 156: 'Russula pseudointegra Arnould & Goris', 157: 'Russula puellaris Fr.', 
               158: 'Russula queletii Fr.', 159: 'Russula risigallina (Batsch) Sacc.', 160: 'Russula romellii Maire', 
               161: 'Russula roseoaurantia Sarnari', 162: 'Russula sanguinea (Bull.) Fr.', 163: 'Russula sardonia Fr.', 
               164: 'Russula seperina Dupain', 165: 'Russula silvestris (Singer) Reumaux', 166: 'Russula solaris Ferd. & Winge', 
               167: 'Russula sororia Fr.', 168: 'Russula subrubens (J.E.Lange) Bon', 169: 'Russula undulata Velen.', 
               170: 'Russula velenovskyi Melzer & Zvára', 171: 'Russula velutipes Velen.', 172: 'Russula versicolor Jul.Schäff.', 
               173: 'Russula vesca Fr.', 174: 'Russula veternosa Fr.', 175: 'Russula violeipes Quél.', 
               176: 'Russula virescens (Schaeff.) Fr.', 177: 'Russula viscida Kudrna', 178: 'Russula xerampelina (Schaeff.) Fr.', 
               179: 'Singerocybe phaeophthalma (Pers.) Harmaja', 180: 'Xerocomus ferrugineus (Schaeff.) Bon', 
               181: 'Xerocomus subtomentosus (L.) Fr.'}


PATH = 'test2_25.pt'
model_ft = torch.load(PATH, map_location ='cpu')
model_ft.eval()

def predict(img_array):
    was_training = model_ft.training
    model_ft.eval()
    img = Image.fromarray(img_array).convert('RGB')
    #img = Image.open(img_path)
    img = data_transforms['val'](img)
    img = img.unsqueeze(0)
    img = img.to(device)

    with torch.no_grad():
        outputs = model_ft(img)
        _, preds = torch.max(outputs, 1)
        prediction = torch.nn.functional.softmax(model_ft(img)[0], dim=0)
        confidences = {class_names[i]: float(prediction[i]) for i in range(182)}
        
        """
        ax = plt.subplot(2,2,1)
        ax.axis('off')
        ax.set_title(f'Predicted: {class_names[preds[0]]}')"""
        
        return confidences
        model_ft.train(mode=was_training)

gr.Interface(predict, inputs="image", outputs=gr.outputs.Label(num_top_classes=4), examples = ['mushroom1.jpg', 'mushroom2.jpg'], 
             title="Mushroom classifier").queue(concurrency_count=1).launch()