export async function extractEmbeddings(
  worker,
  weightsURL,
  tokenizerURL,
  configURL,
  modelID,
  sentences,
  updateStatus,
  normalize_embeddings = true
) {
  return new Promise((resolve, reject) => {
    worker.postMessage({
      weightsURL,
      tokenizerURL,
      configURL,
      modelID,
      sentences,
      normalize_embeddings,
    });
    function messageHandler(event) {
      if ("error" in event.data) {
        worker.removeEventListener("message", messageHandler);
        reject(new Error(event.data.error));
      }
      if (event.data.status === "complete") {
        worker.removeEventListener("message", messageHandler);
        resolve(event.data);
      }
      if (updateStatus) updateStatus(event.data);
    }
    worker.addEventListener("message", messageHandler);
  });
}

export async function generateText(
  worker,
  weightsURL,
  tokenizerURL,
  configURL,
  modelID,
  prompt,
  params,
  updateStatus
) {
  return new Promise((resolve, reject) => {
    worker.postMessage({
      weightsURL,
      tokenizerURL,
      configURL,
      modelID,
      prompt,
      params,
    });
    function messageHandler(event) {
      if ("error" in event.data) {
        worker.removeEventListener("message", messageHandler);
        reject(new Error(event.data.error));
      }
      if (event.data.status === "complete") {
        worker.removeEventListener("message", messageHandler);
        resolve(event.data);
      }
      if (updateStatus) updateStatus(event.data);
    }
    worker.addEventListener("message", messageHandler);
  });
}

const tasks = {
  translation_en_to_de: {
    prefix: "translate English to German: ",
    max_length: 300,
  },
  translation_en_to_fr: {
    prefix: "translate English to French: ",
    max_length: 300,
  },
  translation_en_to_ro: {
    prefix: "translate English to Romanian: ",
    max_length: 300,
  },
  summarization: { prefix: "summarize: ", max_length: 200 },
  fluency: {
    prefix: "Fix the grammar: ",
    max_length: 300,
  },
  coherence: {
    prefix: "Rewrite to make this easier to understand: ",
    max_length: 300,
  },
  simplification: {
    prefix: "translate English to Romanian: ",
    max_length: 300,
  },
  simplification: {
    prefix: "Paraphrase this: ",
    max_length: 300,
  },
  formalization: {
    prefix: "Write this more formally: ",
    max_length: 300,
  },
  neutralize: {
    prefix: "Write in a more neutral way: ",
    max_length: 300,
  },
};

export const MODELS = {
  "LaMini-Flan-T5-248M-candle-q2k.gguf": {
    size: "81.4 MB",
    base_url:
      "https://huggingface.co/Felladrin/candle-quantized-LaMini-Flan-T5-248M/resolve/main/",
    model: "LaMini-Flan-T5-248M-candle-q2k.gguf",
    tokenizer: "tokenizer.json",
    config: "config.json",
    tasks,
  },
  "LaMini-Flan-T5-248M-candle-q3k.gguf": {
    size: "106.6 MB",
    base_url:
      "https://huggingface.co/Felladrin/candle-quantized-LaMini-Flan-T5-248M/resolve/main/",
    model: "LaMini-Flan-T5-248M-candle-q3k.gguf",
    tokenizer: "tokenizer.json",
    config: "config.json",
    tasks,
  },
  "LaMini-Flan-T5-248M-candle-q4k.gguf": {
    size: "139.5 MB",
    base_url:
      "https://huggingface.co/Felladrin/candle-quantized-LaMini-Flan-T5-248M/resolve/main/",
    model: "LaMini-Flan-T5-248M-candle-q4k.gguf",
    tokenizer: "tokenizer.json",
    config: "config.json",
    tasks,
  },
  "LaMini-Flan-T5-248M-candle-q5k.gguf": {
    size: "170.4 MB",
    base_url:
      "https://huggingface.co/Felladrin/candle-quantized-LaMini-Flan-T5-248M/resolve/main/",
    model: "LaMini-Flan-T5-248M-candle-q5k.gguf",
    tokenizer: "tokenizer.json",
    config: "config.json",
    tasks,
  },
  "LaMini-Flan-T5-248M-candle-q6k.gguf": {
    size: "203.3 MB",
    base_url:
      "https://huggingface.co/Felladrin/candle-quantized-LaMini-Flan-T5-248M/resolve/main/",
    model: "LaMini-Flan-T5-248M-candle-q6k.gguf",
    tokenizer: "tokenizer.json",
    config: "config.json",
    tasks,
  },
  "LaMini-Flan-T5-248M-candle-q8k.gguf": {
    size: "282.6 MB",
    base_url:
      "https://huggingface.co/Felladrin/candle-quantized-LaMini-Flan-T5-248M/resolve/main/",
    model: "LaMini-Flan-T5-248M-candle-q8k.gguf",
    tokenizer: "tokenizer.json",
    config: "config.json",
    tasks,
  },
};

export function getModelInfo(id, taskID) {
  const model = MODELS[id];
  return {
    modelURL: model.base_url + model.model,
    configURL: model.base_url + model.config,
    tokenizerURL: model.base_url + model.tokenizer,
    maxLength: model.tasks[taskID].max_length,
  };
}
