coco_category_index = {
    1: {'id': 1, 'name': 'person'},
    2: {'id': 2, 'name': 'bicycle'},
    3: {'id': 3, 'name': 'car'},
    4: {'id': 4, 'name': 'motorcycle'},
    5: {'id': 5, 'name': 'airplane'},
    6: {'id': 6, 'name': 'bus'},
    7: {'id': 7, 'name': 'train'},
    8: {'id': 8, 'name': 'truck'},
    9: {'id': 9, 'name': 'boat'},
    10: {'id': 10, 'name': 'traffic light'},
    11: {'id': 11, 'name': 'fire hydrant'},
    13: {'id': 13, 'name': 'stop sign'},
    14: {'id': 14, 'name': 'parking meter'},
    15: {'id': 15, 'name': 'bench'},
    16: {'id': 16, 'name': 'bird'},
    17: {'id': 17, 'name': 'cat'},
    18: {'id': 18, 'name': 'dog'},
    19: {'id': 19, 'name': 'horse'},
    20: {'id': 20, 'name': 'sheep'},
    21: {'id': 21, 'name': 'cow'},
    22: {'id': 22, 'name': 'elephant'},
    23: {'id': 23, 'name': 'bear'},
    24: {'id': 24, 'name': 'zebra'},
    25: {'id': 25, 'name': 'giraffe'},
    27: {'id': 27, 'name': 'backpack'},
    28: {'id': 28, 'name': 'umbrella'},
    31: {'id': 31, 'name': 'handbag'},
    32: {'id': 32, 'name': 'tie'},
    33: {'id': 33, 'name': 'suitcase'},
    34: {'id': 34, 'name': 'frisbee'},
    35: {'id': 35, 'name': 'skis'},
    36: {'id': 36, 'name': 'snowboard'},
    37: {'id': 37, 'name': 'sports ball'},
    38: {'id': 38, 'name': 'kite'},
    39: {'id': 39, 'name': 'baseball bat'},
    40: {'id': 40, 'name': 'baseball glove'},
    41: {'id': 41, 'name': 'skateboard'},
    42: {'id': 42, 'name': 'surfboard'},
    43: {'id': 43, 'name': 'tennis racket'},
    44: {'id': 44, 'name': 'bottle'},
    46: {'id': 46, 'name': 'wine glass'},
    47: {'id': 47, 'name': 'cup'},
    48: {'id': 48, 'name': 'fork'},
    49: {'id': 49, 'name': 'knife'},
    50: {'id': 50, 'name': 'spoon'},
    51: {'id': 51, 'name': 'bowl'},
    52: {'id': 52, 'name': 'banana'},
    53: {'id': 53, 'name': 'apple'},
    54: {'id': 54, 'name': 'sandwich'},
    55: {'id': 55, 'name': 'orange'},
    56: {'id': 56, 'name': 'broccoli'},
    57: {'id': 57, 'name': 'carrot'},
    58: {'id': 58, 'name': 'hot dog'},
    59: {'id': 59, 'name': 'pizza'},
    60: {'id': 60, 'name': 'donut'},
    61: {'id': 61, 'name': 'cake'},
    62: {'id': 62, 'name': 'chair'},
    63: {'id': 63, 'name': 'couch'},
    64: {'id': 64, 'name': 'potted plant'},
    65: {'id': 65, 'name': 'bed'},
    67: {'id': 67, 'name': 'dining table'},
    70: {'id': 70, 'name': 'toilet'},
    72: {'id': 72, 'name': 'tv'},
    73: {'id': 73, 'name': 'laptop'},
    74: {'id': 74, 'name': 'mouse'},
    75: {'id': 75, 'name': 'remote'},
    76: {'id': 76, 'name': 'keyboard'},
    77: {'id': 77, 'name': 'cell phone'},
    78: {'id': 78, 'name': 'microwave'},
    79: {'id': 79, 'name': 'oven'},
    80: {'id': 80, 'name': 'toaster'},
    81: {'id': 81, 'name': 'sink'},
    82: {'id': 82, 'name': 'refrigerator'},
    84: {'id': 84, 'name': 'book'},
    85: {'id': 85, 'name': 'clock'},
    86: {'id': 86, 'name': 'vase'},
    87: {'id': 87, 'name': 'scissors'},
    88: {'id': 88, 'name': 'teddy bear'},
    89: {'id': 89, 'name': 'hair drier'},
    90: {'id': 90, 'name': 'toothbrush'},
}

rgb_colors = {
    1: (240, 248, 255),
    2: (250, 235, 215),
    3: (0, 255, 255),
    4: (127, 255, 212),
    5: (240, 255, 255),
    6: (245, 245, 220),
    7: (255, 228, 196),
    8: (255, 255, 255),
    9: (255, 235, 205),
    10: (0, 0, 255),
    11: (138, 43, 226),
    12: (165, 42, 42),
    13: (222, 184, 135),
    14: (95, 158, 160),
    15: (127, 255, 0),
    16: (210, 105, 30),
    17: (255, 127, 80),
    18: (100, 149, 237),
    19: (255, 248, 220),
    20: (220, 20, 60),
    21: (0, 255, 255),
    22: (0, 0, 139),
    23: (0, 139, 139),
    24: (184, 134, 11),
    25: (169, 169, 169),
    26: (0, 100, 0),
    27: (169, 169, 169),
    28: (189, 183, 107),
    29: (139, 0, 139),
    30: (85, 107, 47),
    31: (255, 140, 0),
    32: (153, 50, 204),
    33: (139, 0, 0),
    34: (233, 150, 122),
    35: (143, 188, 143),
    36: (72, 61, 139),
    37: (47, 79, 79),
    38: (47, 79, 79),
    39: (0, 206, 209),
    40: (148, 0, 211),
    41: (255, 20, 147),
    42: (0, 191, 255),
    43: (105, 105, 105),
    44: (105, 105, 105),
    45: (30, 144, 255),
    46: (178, 34, 34),
    47: (255, 250, 240),
    48: (34, 139, 34),
    49: (255, 0, 255),
    50: (220, 220, 220),
    51: (248, 248, 255),
    52: (255, 215, 0),
    53: (218, 165, 32),
    54: (128, 128, 128),
    55: (0, 128, 0),
    56: (173, 255, 47),
    57: (128, 128, 128),
    58: (240, 255, 240),
    59: (255, 105, 180),
    60: (205, 92, 92),
    61: (75, 0, 130),
    62: (255, 0, 122),
    63: (240, 230, 140),
    64: (230, 230, 250),
    65: (255, 240, 245),
    66: (124, 252, 0),
    67: (255, 250, 205),
    68: (173, 216, 230),
    69: (240, 128, 128),
    70: (224, 255, 255),
    71: (250, 250, 210),
    72: (211, 211, 211),
    73: (144, 238, 144),
    74: (211, 211, 211),
    75: (255, 182, 193),
    76: (255, 160, 122),
    77: (32, 178, 170),
    78: (135, 206, 250),
    79: (119, 136, 153),
    80: (119, 136, 153),
    81: (176, 196, 222),
    82: (255, 255, 224),
    83: (0, 255, 0),
    84: (50, 205, 50),
    85: (250, 240, 230),
    86: (255, 0, 255),
    87: (128, 0, 0),
    88: (102, 205, 170),
    89: (0, 0, 205),
    90: (186, 85, 211),
}

color_pose = { # BGR
    "purple": (255, 0, 100),
    "light_pink": (80, 0, 255),
    "dark_pink": (220, 0, 255),
    "light_orange": (255, 80, 0),
    "dark_orange": (255, 220, 0.),
    "yellow": (0, 220, 255),
    "blue": (255, 0, 0),
    "green": (0,255,0),
}

color_pose_rgb= { # RGB
    "purple": (100, 0, 255),
    "light_pink": (255, 0, 80),
    "dark_pink": (255, 0, 220),
    "light_orange": (0, 80, 255),
    "dark_orange": (0, 220, 255.),
    "yellow": (255, 220, 0),
    "blue": (0, 0, 255),
    "green": (0,255,0),
}


color_pose_normalized = {
    "purple": (100/255., 0/255., 255/255.),
    "light_pink": (255/255., 0/255., 80/255.),
    "dark_pink": (255/255., 0/255., 220/255.),
    "light_orange": (255/255., 80/255., 0/255.),
    "dark_orange": (255/255., 220/255., 0/255.),
    "blue": (0/255., 0/255., 255/255.)
}

pose_id_part = {
    0: "Nose",# purple
    1: "LEye",#light_pink
    2: "REye",#dark_pink
    3: "LEar",#light_orange
    4: "REar",#yellow
    5: "LShoulder",
    6: "RShoulder",
    7: "LElbow",
    8: "RElbow",
    9: "LWrist",
    10: "RWrist",
    11: "LHip",
    12: "RHip",
    13: "LKnee",
    14: "RKnee",
    15: "LAnkle",
    16: "RAnkle"
}

rev_pose_id_part = {value: key for key, value in pose_id_part.items()}

pose_id_part_openpose = {
    0:  "Nose",
    1:  "Neck",
    2:  "RShoulder",
    3:  "RElbow",
    4:  "RWrist",
    5:  "LShoulder",
    6:  "LElbow",
    7:  "LWrist",
    8:  "MidHip",
    9:  "RHip",
    10: "RKnee",
    11: "RAnkle",
    12: "LHip",
    13: "LKnee",
    14: "LAnkle",
    15: "REye",
    16: "LEye",
    17: "REar",
    18: "LEar",
    19: "LBigToe",
    20: "LSmallToe",
    21: "LHeel",
    22: "RBigToe",
    23: "RSmallToe",
    24: "RHeel",
    25: "Background"
}

pose_id_part_zedcam = {
    0: "Nose",
    1: "Neck",
    2: "RShoulder",
    3: "RElbow",
    4: "RWrist",
    5: "LShoulder",
    6: "LElbow",
    7: "LWrist",
    8: "RHip",
    9: "RKnee",
    10: "RAnkle",
    11: "LHip",
    12: "LKnee",
    13: "LAnkle",
    14: "REye",
    15: "LEye",
    16: "REar",
    17: "LEar",
}
pose_id_part_centernet = {
    0:  "Nose",
    1:  "Neck",
    2:  "RShoulder",
    3:  "RElbow",
    4:  "RWrist",
    5:  "LShoulder",
    6:  "LElbow",
    7:  "LWrist",
    8:  "MidHip",
    9:  "RHip",
    10: "RKnee",
    11: "RAnkle",
    12: "LHip",
    13: "LKnee",
    14: "LAnkle",
    15: "REye",
    16: "LEye",
    17: "REar",
    18: "LEar",
    19: "LBigToe",
    20: "LSmallToe",
    21: "LHeel",
    22: "RBigToe",
    23: "RSmallToe",
    24: "RHeel",
    25: "Background"
}

rev_pose_id_part_openpose = {value: key for key, value in pose_id_part_openpose.items()}

face_category_index = {
    1: {'id': 1, 'name': 'Face'},
}

tracking_colors = {
    0: (255, 0, 0),
    1: (0, 255, 0),
    2: (0, 0, 255),
    3: (255, 0, 255),
    4: (255, 255, 0),
    5: (0, 255, 255),
    6: (255, 255, 255),
    7: (0, 0, 0),
    8: (128, 128, 128),
    9: (128, 0, 0),
    10: (0, 128, 0),
    11: (0, 0, 128),
    12: (128, 128, 0),
    13: (128, 0, 128),
    14: (0, 128, 128),
}

body_parts = [(5, 6), (5, 7), (6, 8), (7, 9), (8, 10), (11, 12), (5, 11), (6, 12), (11, 13), (12, 14), (13, 15), (14, 16)]

body_parts_openpose = [(5, 2), (5, 6), (2, 3), (6, 7), (3, 4), (12, 9), (5, 12), (2, 9), (12, 13), (9, 10), (13, 14),
                       (10, 11)]

body_parts_zedcam = [(5, 2), (5, 6), (2, 3), (6, 7), (3, 4), (11, 8), (5, 11), (2, 8), (11, 12), (8, 9), (12, 13),
                       (9, 10)]

face_points = [0, 1, 2, 3, 4]

face_points_openpose = [0, 16, 15, 18, 17]

face_points_zedcam = [0, 14, 15, 16, 17]