# This Python 3 environment comes with many helpful analytics libraries installed
# It is defined by the kaggle/python Docker image: https://github.com/kaggle/docker-python
# For example, here's several helpful packages to load

import numpy as np # linear algebra
import pandas as pd # data processing, CSV file I/O (e.g. pd.read_csv)

# Input data files are available in the read-only "../input/" directory
# For example, running this (by clicking run or pressing Shift+Enter) will list all files under the input directory

import os
for dirname, _, filenames in os.walk('/kaggle/input'):
    for filename in filenames:
        print(os.path.join(dirname, filename))

# You can write up to 20GB to the current directory (/kaggle/working/) that gets preserved as output when you create a version using "Save & Run All" 
# You can also write temporary files to /kaggle/temp/, but they won't be saved outside of the current session

#|default_exp app

#|export
#pip install fastbook
import fastbook
from fastbook import *
#pip install fastai
from fastai.vision.widgets import *
#pip install gradio
import gradio as gr

import IPython
from IPython.display import display
from PIL import Image

import pathlib
#temp = pathlib.PosixPath
#pathlib.PosixPath = pathlib.WindowsPath
plt = platform.system()
if plt == 'Linux': pathlib.WindowsPath = pathlib.PosixPath

def search_images(term, max_images=999999):
    print(f"Searching for '{term}'")
    return search_images_ddg(term, max_images)

learn = load_learner('model.pkl')

breeds = ('Labrador Retrievers','German Shepherds','Golden Retrievers','French Bulldogs','Bulldogs','Beagles','Poodles','Rottweilers','Chihuahua')

def classify_image(img):
    pred,idx,probs = learn.predict(img)
    #return dict(zip(breeds, map(float,probs)))
    return "This is " + pred

image = gr.components.Image()
label = gr.components.Label()

examples = ['dog.jpg','labrador.jpeg','dunno.jpg']

for x in examples:
    Image.open(x)

intf = gr.Interface(fn=classify_image, inputs=image, outputs=label, examples=examples)
intf.launch(inline=False)