import random
import yaml
import gradio as gr

def generate_text():
    input_data = get_options('female.yaml')
    command = input_data['command']
    for key in input_data.keys():
        if key != 'command':
            command = command.replace(f'[{key}]', input_data[key][random.randint(0, len(input_data[key]) - 1)])
    return command

def get_options(file_path):
    with open(file_path, 'r') as file:
        options = yaml.load(file, Loader=yaml.FullLoader)
    return options

iface = gr.Interface(
    fn=generate_text,
    inputs=None,
    outputs=gr.outputs.Textbox(label="Generated Text"),
    title="Beautiful Female AI Generator Prompts",
    description="Generates a random text prompt for a female by AI ",
    allow_flagging=False,
    theme="compact",
    examples=[
        ["Generate"],
        ["Generate"],
        ["Generate"]
    ],
    # Add image to the interface
    #image="https://iraqprogrammer.files.wordpress.com/2023/03/00045-3227812873.png?w=1400&h="
)

iface.launch()
