import gradio as gr
from transformers import pipeline

classifier = pipeline("zero-shot-classification", model="facebook/bart-large-mnli")

def zeroShotClassification(text_input, candidate_labels):
  labels = [label.strip(' ') for label in candidate_labels.split(',')]
  output = {}
  prediction = classifier(text_input, labels)
  for i in range(len(prediction['labels'])):
    output[prediction['labels'][i]] = prediction['scores'][i]
  return output

examples = [["One day I will see the world", "travel, live, die, future"]]

demo = gr.Interface(fn=zeroShotClassification, inputs=[gr.Textbox(label="Input"), gr.Textbox(label="Candidate Labels")], outputs=gr.Label(label="Classification"), examples=examples)
demo.launch()