import gradio as gr
from transformers import AutoModelWithLMHead, AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained("mrm8488/t5-base-finetuned-question-generation-ap")
model = AutoModelWithLMHead.from_pretrained("mrm8488/t5-base-finetuned-question-generation-ap")

def get_question(context, answer, max_length=64):
  input_text = "answer: %s  context: %s </s>" % (answer, context)
  features = tokenizer([input_text], return_tensors='pt')

  output = model.generate(input_ids=features['input_ids'], 
               attention_mask=features['attention_mask'],
               max_length=max_length)

  return tokenizer.decode(output[0])[16:-4]

examples = [["The world's first piece of software was written by a computer scientist named Tom Kilburn in 1948.", "1948"], ["The world's first piece of software was written by a computer scientist named Tom Kilburn in 1948.", "Tom Kilburn"], ["The world's first piece of software was written by a computer scientist named Tom Kilburn in 1948.", "computer scientist"]]

css = """
.footer {display:none !important}
"""

demo = gr.Interface(fn=get_question, inputs=[gr.Textbox(lines=3, placeholder="Enter text here", label="Context"), gr.Textbox(lines=1, label="Answer")], outputs=gr.Textbox(label="Generated Question"), examples=examples, css=css)
demo.launch()