import gradio as gr
import numpy as np
import pandas as pd
import matplotlib.pyplot as plt
from pycaret.regression import *

cvr_saved = load_model('pred_cvr')

def predict_cvr(xyz_campaign_id, gender, age, Impressions, Clicks, 
                Total_Conversion, interest): 
  path = "KAG_conversion_data.csv" 
  df = pd.read_csv(path) 
  df.drop(["ad_id", "fb_campaign_id", "Spent","Approved_Conversion"],axis=1, inplace = True) 
  df = pd.DataFrame.from_dict({'xyz_campaign_id': [xyz_campaign_id], 'gender': [gender], 'age': [age], 'Impressions': [Impressions], 
  'Clicks': [Clicks], 'Total_Conversion': [Total_Conversion], 'interest': [interest]}) 
  df["xyz_campaign_id"].replace({916:"campaign_a",936:"campaign_b",1178:"campaign_c"}, inplace=True) 
  pred = cvr_saved.predict(df).tolist()[0] 
  return 'Conversion Rate : '+str(pred) 
  
xyz_campaign_id = gr.inputs.Dropdown(['campaign_a', 'campaign_b', 'campaign_c'], label="xyz_campaign_id -> an ID associated with each ad campaign of XYZ company")
gender = gr.inputs.Dropdown(['M', 'F'], label = "gender -> gender of the person to whom the add is shown")
age = gr.inputs.Dropdown(['30-34', '35-39', '40-44', '45-49'], label = "age -> age of the person to whom the ad is shown")
Impressions = gr.inputs.Slider(minimum=100, maximum=3000000, default = 50000, step=100, label =  "Impressions -> the number of times the ad was shown")
Clicks = gr.inputs.Slider(minimum=1, maximum=500, default = 8, step=1, label = "Clicks -> number of clicks on for that ad")
Total_Conversion = gr.inputs.Slider(minimum= 1, maximum= 60, default = 1, step= 1, label = "Total_Conversion -> the number of people who responded to the product after seeing the ad") 
interest = gr.inputs.Slider(minimum=1, maximum=114, default = 25, step= 1, label = "interest -> a code specifying the category to which the person’s interest belongs (interests are as mentioned in the person’s Facebook public profile)")

gr.Interface(predict_cvr, inputs =[xyz_campaign_id, gender, age, Impressions, Clicks, 
                Total_Conversion, interest],
             outputs="label",
             title = "Facebook Ads Conversions Prediction Web App",
             theme = "dark-peach",
             capture_session=True).launch();