# # <center> <font color='blue'> **Projet 5: Catégorisez automatiquement des questions**
# # <center> <font color='goldenrode'> **Notebook: API**
#     
# ## link to the created HuggingFace Space:
#     
# # https://huggingface.co/spaces/FadouaFGM/Stackoverflow_Questions_Categorisation
# 
#         
# <center><img src="stackoverflow2.png" align="center"/> </center>

# 
# 
# **On commence tout d'abord par la définition des fonctions globales utilisées pour le nettoyage du texte, ensuite la vectorisation et le modèle ML choisi lors de l'étude menée dans le notebook précédent.**




from sklearn.pipeline import Pipeline
from sklearn.feature_extraction.text import CountVectorizer
from sklearn.multiclass import OneVsRestClassifier
from sklearn.linear_model import LogisticRegression
from sklearn.decomposition import LatentDirichletAllocation
import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
import seaborn as sns
import time
import warnings
import re
import nltk
import spacy
import re

from nltk.tokenize import WordPunctTokenizer
from nltk.corpus import stopwords

nlp = spacy.load("en_core_web_sm")
nlp.Defaults.stop_words.add("`,")
nlp.Defaults.stop_words.add("``")


# ### **Définition des fonctions et modèle**


# Define functions

#lemmatize text without stop or punctuation words
def lemmatize(text):
    doc = nlp(text)
    tokens = [token.lemma_ for token in doc if not (token.is_stop or token.is_digit or token.is_punct)]
    return ' '.join(tokens)

def tokenization(text):
    tokens = WordPunctTokenizer().tokenize(text)
    return tokens


# Function to preprocess text
def clean(text):
    # Lower case
    text = text.lower()
    # Removing paragraph numbers
    text = re.sub(r'[0-9]+.\t', '', text)
    # Change the pattern C# to csharp
    pattern = r'c\#' 
    text = re.sub(pattern, 'csharp', text)
    # Removing web and HTML links
    text = re.sub(r'http\S+', '', text)
    # Removing special characters
    text = re.sub("</p>", '', str(text))
    text = re.sub("<p>", '', str(text))
    text = re.sub("</pre>", '', str(text))
    text = re.sub("<pre>", '', str(text))
    text = re.sub("&", '', str(text))
    text = re.sub(";", '', str(text))
    text = re.sub("gt", ' ', str(text))
    text = re.sub("pre", '', str(text))
    # Removing any reference to outside text
    text = re.sub("[\(\[].*?[\)\]]", "", str(text))
    # Removing numbers
    text = re.sub('[0-9]', '', str(text))
    # Removing new line characters
    text = re.sub('\n ', '', str(text))
    text = re.sub('\n', ' ', str(text))
    # Removing apostrophes
    text = re.sub("'s", '', str(text))
    # Removing hyphens
    text = re.sub("-", ' ', str(text))
    text = re.sub("—", '', str(text))
    # Removing > or < or = signs
    text = re.sub("<", ' ', str(text))
    text = re.sub(">", '', str(text))
    text = re.sub("=", '', str(text))
    # Removing quotation marks
    text = re.sub('\"', '', str(text))
    # Removing quotation marks
    text = re.sub('/', '', str(text))
    # Use regex to delete all what's inside < >
    CLEANR = re.compile('<.*?>')
    text = re.sub(CLEANR, '', text)
    
    return text

def remove_code(text):
    
    #first position of the code in code
    codepointer=text.find('<code>')
    result=''
    
    while codepointer!=-1:
        #last position of /code
        codeender=text.find(u'</code>',codepointer)
        #the code between pointer and ender
        result=result+text[codepointer:codeender+7]
        codepointer=text.find('<code>',codeender)
        
    listOfWords2remove = ([i for i in result.split()])
    
    for i in listOfWords2remove:
        text = text.replace(i, '')    
        
    return text

def text_processing(dfoftext):
    
    cleaneddftext = dfoftext.apply(lambda txt : remove_code(txt))
    cleaneddftext = cleaneddftext.apply(lambda txt : clean(txt))
    cleaneddftext = cleaneddftext.apply(lambda txt : lemmatize(txt))
    
    return cleaneddftext

# Define function to predict with the new list of thresholds with attributing a threshold per label
def predict_with_thresholds(y_prob, thresholds):
    y_pred = np.zeros_like(y_prob)
    for i in range(y_prob.shape[1]):
        y_pred[:, i] = (y_prob[:, i] >= thresholds[i]).astype(int)
    return y_pred


import joblib

def makeprediction(text):
    # load the pre-trained TfidfVectorizer from disk
    tfidfvectorizer = joblib.load('tfidf_vectorizer_100523.joblib')
 
    # load the pre-trained Linear_SGD classifier from disk
    ovr = joblib.load('linear_regression_classifier_100523.joblib')
    
    # Processing the text
    cleanedtext = text_processing(text)
    #print(cleanedtext)
    #print(type(cleanedtext))
    
    # applying the model and reconstruction predicted targets
    texttfidf = tfidfvectorizer.transform(cleanedtext)
    
    # make prediction with pretrained classifier
    ypred = ovr.predict_proba(texttfidf)
    #print(ypred)
    
    # recontructing tags from predicted y
    thresholds      = joblib.load('thresholds_100523.joblib')
    labels          = joblib.load('labels_100523.joblib')
    
    y_pred_thr      = predict_with_thresholds(ypred,thresholds)
    #print(y_pred_thr)
    
    tags_pred       = [[labels[i] for i in range(len(yp)) if yp[i] == 1] for yp in y_pred_thr]
    #tags_pred       = tags_pred.apply(lambda x: x if x else ['no predicted labels'])
    
    # Predict with unsupervised model the most important topics and key words related to the document
    # Load unsupervised pretrained model and dictionary
    lda_model = joblib.load('best_lda_model.joblib')
    lda_dictionary = joblib.load('lda_dictionary.joblib')

    # process the document to be a corpus as needed for LDA algorithm
    cleanedtext = pd.Series(cleanedtext)
    text_lda = ' '.join((cleanedtext.tolist())) 
    corpus   = lda_dictionary.doc2bow(text_lda.split())

    # get the topic distribution for the document
    doc_topics = lda_model.get_document_topics(corpus)

    # filter topics with probability > 0.2 and sort them by probability
    important_topics = sorted([(topic, prob) for topic, prob in doc_topics if prob > 0.2], key=lambda x: x[1], reverse=True)

    # print the most important topics related to the document and their probability
    print('The most important topics related to the document, and there probabilities, are:')
    for topic, prob in important_topics:
        print(f'Topic {topic}: {prob:.2f}')

    # get the main keywords for each important topic
    important_topic_ids = [topic for topic, _ in important_topics]
    topic_keywords = lda_model.show_topics(num_topics=-1, formatted=False)
    main_keywords = []
    main_keywords = []
    for topic_id, topic_prob in topic_keywords:
        if topic_id in important_topic_ids:
            keywords = [(word, prob) for word, prob in topic_prob if prob > 0.05]
            main_keywords.append(keywords)

    return tags_pred, important_topics, main_keywords

# ### **Implémentation de l'API: GradioAPI**
import gradio as gra
from typing import List

def predict(text: List[str]):
    data = [[text]]
    data = pd.DataFrame(data, columns = ['Text'])
    tags, topics, keywords = makeprediction(data['Text'])
    #return {"tags!😎": tags, "Related Topics": topics, "Most important key words": keywords }    
    return tags, topics, keywords

inputs = gra.inputs.Textbox(label="Question to predict tags, topics, and keywords", lines=10)
outputs = [
    gra.outputs.Textbox(label="Tags"),
    gra.outputs.Textbox(label="Related Topics"),
    gra.outputs.Textbox(label="Related Keywords")
]
title = "Prediction: Tags, Topics, and Keywords for StackOverflow Questions"

app = gra.Interface(fn=predict, inputs=inputs, outputs=outputs, title=title)

app.launch(debug=True,enable_queue=True)

#link to the created HuggingFace Space
# https://huggingface.co/spaces/FadouaFGM/Stackoverflow_Questions_Categorisation
# Process to update parameters of the model or any other changes on notebooks
# copy all files to the cloned repository
# cp ../Formation_ML/P5/*.joblib .
# cp ../Formation_ML/P5/app.py .
# add all files and commit
# git add .
# git commit -m "Update model parameters"
# git push

#pip freeze > requirements.txt




