from sklearn.pipeline import Pipeline
from sklearn.feature_extraction.text import TfidfVectorizer
from sklearn.multiclass import OneVsRestClassifier
from sklearn.linear_model import LogisticRegression
from sklearn.linear_model import SGDClassifier
from sklearn.preprocessing import MultiLabelBinarizer
import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
import seaborn as sns
import time
import warnings
import re
import nltk
import spacy
import re

from nltk.tokenize import WordPunctTokenizer
from nltk.corpus import stopwords
from typing import List

nlp = spacy.load("en_core_web_sm")
nlp.Defaults.stop_words.add("`,")
nlp.Defaults.stop_words.add("``")

## Définition des fonctions communes

# Define functions

#lemmatize text without stop or punctuation words
def lemmatize(text):
    doc = nlp(text)
    tokens = [token.lemma_ for token in doc if not (token.is_stop or token.is_digit or token.is_punct)]
    return ' '.join(tokens)

def tokenization(text):
    tokens = WordPunctTokenizer().tokenize(text)
    return tokens
# function to preprocess text
def clean(text):
    
    #Lower case
    text = text.lower()
    # removing paragraph numbers
    text = re.sub('[0-9]+.\t','',str(text))
    # change the pattern C# to csharp
    pattern = r'c#' 
    text = re.sub(pattern, 'csharp', text)
    #removing web and html links
    text = re.sub(r'http\S+', '', text)
    # removing special characters
    text = re.sub("</p>",'',str(text))
    text = re.sub("<p>",'',str(text))
    text = re.sub("</pre>",'',str(text))
    text = re.sub("<pre>",'',str(text))
    text = re.sub("&",'',str(text))
    text = re.sub(";",'',str(text))
    text = re.sub("gt",' ',str(text))
    text = re.sub("pre",'',str(text))
    # removing any reference to outside text
    text = re.sub("[\(\[].*?[\)\]]", "", str(text))
    # removing numbers
    text = re.sub('[0-9]','',str(text))
    # removing new line characters
    text = re.sub('\n ','',str(text))
    text = re.sub('\n',' ',str(text))
    # removing apostrophes
    text = re.sub("'s",'',str(text))
    # removing hyphens
    text = re.sub("-",' ',str(text))
    text = re.sub("—",'',str(text))
    # removing > or < or = signs
    text = re.sub("<",' ',str(text))
    text = re.sub(">",'',str(text))
    text = re.sub("=",'',str(text))
    # removing quotation marks
    text = re.sub('\"','',str(text))
    # removing quotation marks
    text = re.sub('/','',str(text))
    # Use regex to delete all what's inside < >
    CLEANR = re.compile('<.*?>') 
    text = re.sub(CLEANR, '', text)
    
    return text

def remove_code(text):
    
    #first position of the code in code
    codepointer=text.find('<code>')
    result=''
    
    while codepointer!=-1:
        #last position of /code
        codeender=text.find(u'</code>',codepointer)
        #the code between pointer and ender
        result=result+text[codepointer:codeender+7]
        codepointer=text.find('<code>',codeender)
        
    listOfWords2remove = ([i for i in result.split()])
    
    for i in listOfWords2remove:
        text = text.replace(i, '')    
        
    return text
####
def text_processing(dfoftext):
    
    cleaneddftext = dfoftext.apply(lambda txt : remove_code(txt))
    cleaneddftext = cleaneddftext.apply(lambda txt : clean(txt))
    cleaneddftext = cleaneddftext.apply(lambda txt : lemmatize(txt))
    
    return cleaneddftext

# Define function to predict with the new list of thresholds with attributing a threshold per label
def predict_with_thresholds(y_prob, thresholds):
    y_pred = np.zeros_like(y_prob)
    for i in range(y_prob.shape[1]):
        y_pred[:, i] = (y_prob[:, i] >= thresholds[i]).astype(int)
    return y_pred

import joblib

import joblib

def makeprediction(text):
    # load the pre-trained TfidfVectorizer from disk
    counter = joblib.load('count_vectorizer.joblib')
    
    # load the pre-trained Linear_SGD classifier from disk
    ovr = joblib.load('linear_sgd_classifier.joblib')
    
    # Processing the text
    cleanedtext = text_processing(text)
    #print(cleanedtext)
    #print(type(cleanedtext))
    
    # applying the model and reconstruction predicted targets
    textcv = counter.transform(cleanedtext)
    
    # make prediction with pretrained classifier
    ypred = ovr.predict_proba(textcv)
    #print(ypred)
    
    # recontructing tags from predicted y
    thresholds      = joblib.load('thresholds.joblib')
    labels          = joblib.load('labels.joblib')
    
    y_pred_thr      = predict_with_thresholds(ypred,thresholds)
    #print(y_pred_thr)
    
    tags_pred       = [[labels[i] for i in range(len(yp)) if yp[i] == 1] for yp in y_pred_thr]
    #tags_pred       = tags_pred.apply(lambda x: x if x else ['no predicted labels'])
    
    return tags_pred
    
#creating a gradio interface
import gradio as gra
def predict(text: List[str]):
    data = [[text]]
    data = pd.DataFrame(data, columns = ['Text'])
    tags = makeprediction(data['Text'])
    return {"tags!😎": tags}    

#define gradio interface and other parameters
app =  gra.Interface(fn = predict, inputs="text", outputs="text")
app.launch(debug=True,enable_queue=True)