# This file is used to create an SQLite database.
# If adding more tables, you should delete the exising databases, or alter the code here to drop the pre-exising tables first.
import sqlite3

# Establishes a connection to the specified DB. If the DB does not exist, it creates a new one.
connection = sqlite3.connect("Refineverse.db")
cursor = connection.cursor() # A cursor object that is used to handle data.

# Creating the Breakdown table
cursor.execute('''
    CREATE TABLE IF NOT EXISTS Breakdown (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        user_story TEXT,
        assignedLabel TEXT
    )
''')

# Creating the TextSummarization table
cursor.execute('''
    CREATE TABLE IF NOT EXISTS TextSummarization (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        Entered_story TEXT,
        summary TEXT
    )
''')

# Creating the Translation table
cursor.execute('''
    CREATE TABLE IF NOT EXISTS Translation (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        input_text TEXT,
        translated_text TEXT
    )
''')

# Creating the TextGeneration table
cursor.execute('''
    CREATE TABLE IF NOT EXISTS TextGeneration (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        userStory TEXT,
        generatedStory TEXT
    )
''')

connection.close() # Closes the connection