import re # Python's built-in library for regular expressions (or Regex)
import sqlite3
from flask import g
from transformers import pipeline

# Main function of the summarization feature. Performs summarization!
def summarize(Entered_story):
    
    # Check if the input is empty
    if not Entered_story.strip():
        raise ValueError("Empty input!")
    
    # Validate that the input is in the correct format
    if not validate_story(Entered_story):
        raise ValueError("Incorrect format!")
    
    # Before we do anything, make sure the input is long enough for summarization.
    if len(Entered_story) < 200:
        raise ValueError("Invalid length!")
    
    # Set the pipeline to use the correct NLP type and model
    summarizer = pipeline("summarization", model="facebook/bart-large-cnn")
        
    # Take note: The max_length & min_length variables refer to the OUTPUT length!
    summary = summarizer(Entered_story, max_length=100, min_length=30, do_sample=False)[0]["summary_text"]
    
    return summary

# User Input Format Validation Function for English only
def validate_story(Entered_story):
    pattern = r'As a (?P<role>[^,.]+), I want to (?P<goal>[^,.]+)(,|.)+so that (?P<benefit>.+)'
    match = re.search(pattern, Entered_story, flags=re.DOTALL)
    return bool(match)

# Function to grab all contents in the "TextSummarization" table (except for unique ids)
def getTextSumContents():
    db = getattr(g, '_database', None) # Gets the _database attribute from the 'g' object. If it does not exist, returns 'None'
    if db is None:
        db = g._database = sqlite3.connect('Refineverse.db') # If db is None, create a new connection for db and g._database.
        cursor = db.cursor() # Creates a cursor object to handle data
        cursor.execute("SELECT Entered_story, summary FROM TextSummarization") # The cursor executes the query
        rows = cursor.fetchall() # Stores the results of fetchall() into a variable
    return rows

# Function to insert a new row into the "TextSummarization" table
def insertTextSumRow( Entered_story, summary):
    with sqlite3.connect('Refineverse.db') as conn: # 'With' will automatically take care of closing and opening the connection
        cursor = conn.cursor()
        cursor.execute("INSERT INTO TextSummarization (Entered_story, summary) VALUES (?, ?)", (Entered_story, summary))
        conn.commit()
