import gradio as gr

from convert import convert

DESCRIPTION = """
<div style="display: flex; flex-wrap: wrap; gap: 10px; align-items: center;">
  <p>🥽 Tested on: </p> <a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-0.9" target="_new" rel="ugc"><img src="https://img.shields.io/badge/stable--diffusion--xl--base--0.9-Model-purple" alt="stable-diffusion-xl-base-0.9"></a>
  <p>&</p>
  <a href="https://huggingface.co/FFusion/FFusionXL-09-SDXL" target="_new" rel="ugc"><img src="https://img.shields.io/badge/FFusionXL--09--SDXL-Model-pink" alt="FFusionXL-09-SDXL"></a>
</div>

The steps are the following:

- Paste a read-access token from hf.co/settings/tokens. Read access is enough given that we will open a PR against the source repo.
- Input a model id from the Hub
- Input the filename from the root dir of the repo that you would like to convert, e.g. 'xl-pruned.safetensors'
- Click "Submit"
- That's it! You'll get feedback if it works or not, and if it worked, you'll get the URL of the opened PR 🔥

⚠️ If you encounter weird error messages, please have a look into the Logs and feel free to open a PR to correct the error messages.


  <div style="display: flex; flex-wrap: wrap; gap: 2px;">
  <a href="https://huggingface.co/FFusion/FFusion-BaSE" target="_new" rel="ugc"><img src="https://img.shields.io/badge/Hugging%20Face-FFusion--BaSE-blue" alt="Hugging Face Model"></a>
  <a href="https://github.com/1e-2" target="_new" rel="ugc"><img src="https://img.shields.io/badge/GitHub-1e--2-green" alt="GitHub"></a>
  <a href="https://www.facebook.com/FFusionAI/" target="_new" rel="ugc"><img src="https://img.shields.io/badge/Facebook-FFusionAI-blue" alt="Facebook"></a>
  <a href="https://civitai.com/models/82039/ffusion-ai-sd-21" target="_new" rel="ugc"><img src="https://img.shields.io/badge/Civitai-FFusionAI-blue" alt="Civitai"></a>
</div>
    
"""

demo = gr.Interface(
    title="Convert Stable Diffusion XL .safetensors to Diffusers and open a PR",
    description=DESCRIPTION,
    allow_flagging="never",
    article="Check out the [Diffusers from FFXL on HuggingFace](https://huggingface.co/FFusion/FFusionXL-09-SDXL)",
    inputs=[
        gr.Text(max_lines=1, label="your_hf_token"),
        gr.Text(max_lines=1, label="model_id"),
        gr.Text(max_lines=1, label="filename"),
    ],
    outputs=[gr.Markdown(label="output")],
    fn=convert,
).queue(max_size=10, concurrency_count=1)

demo.launch(show_api=True)
