__all__ = ['learner_faces', 'categories', 'classify_faces', 'image', 'label', 'examples', 'intf']

from fastai.vision.all import *
import gradio as gr


learner_attractiveness = load_learner('hotornot.pk1')
categories = ['average','hot', 'or not']

def classify_attractiveness(img):
  prediction, index, probability = learner_attractiveness.predict(img)
  return dict(zip(categories, map(float, probability)))

intf = gr.Interface(fn=classify_attractiveness,
             inputs=gr.Image(shape=(192, 192)),
             outputs=gr.Label(),
             title="Is an Image Hot or Not?",
             description="Input an image, and see if the biased internet gods think it is hot! I suggest NOT using pictures of yourself. It is not as fun. Put your dog or cat or chinchilla in here instead! You can see what the deep learning model sees when you have input enough of them.",
             examples=['img01.jpg', 'img02.jpg', 'img04.jpg', 'img05.jpg', 'img06.jpg', 'img07.jpeg', 'img08.jpg', 'img09.jpg', 'img10.jpg', 'img11.jpg', 'img12.jpg', 'img13.jpg', 'img14.jpg'])
intf.launch(inline=False)


