__all__ = ['learner_faces', 'categories', 'classify_faces', 'image', 'label', 'examples', 'intf']

from fastai.vision.all import *
import gradio as gr


learner_faces = load_learner('faces_resenet50_78.pk1')
categories = ['sad', 'happy', 'angry']

def classify_faces(img):
  prediction, index, probability = learner_faces.predict(img)
  return dict(zip(categories, map(float, probability)))

intf = gr.Interface(fn=classify_faces,
             inputs=gr.Image(shape=(192, 192)),
             outputs=gr.Label(),
             title='Happy, Sad, or Angry?',
             description="Put in a picture and see what the AI thinks the expression on the face is. Happy is easy, but sad and angry are eerily similar!",
             examples=['face01.jpg', 'face13.jpg', 'face02.jpg', 'face07.jpg', 'face10.jpeg', 'face11.jpg', 'face03.jpg', 'face04.jpg', 'face12.jpg', 'face05.jpg', 'face09.jpeg', 'face06.jpg', 'face08.jpeg'])
intf.launch(inline=False)


