__all__ = ['is_cat', 'learner_pets', 'categories', 'classify_pet', 'image', 'label', 'examples', 'intf']

import fastai
from fastai.vision.all import *
import gradio as gr

def is_cat(x): return x[0].isupper()

learner_pets = load_learner('cats_dogs.pk1')
categories = ['Dog', 'Cat']

def classify_pet(img):
  prediction, index, probability = learner_pets.predict(img)
  return dict(zip(categories, map(float, probability)))

intf = gr.Interface(fn=classify_pet,
             inputs=gr.Image(shape=(192, 192)),
             outputs=gr.Label(),
             title="Cat or Dog?!",
             description = 'Put in a picture of a cat or a dog, and this tiny deep learning model will tell you which it is. It is also to try it out on yourself or people you know! Are you REALLY a cat person or a dog person?!',
             examples=['dog.jpeg', 'cat.png', 'dog2.jpeg', 'dog03.jpeg', 'acat.jpg', 'not_sure.jpeg'])
intf.launch(inline=False)


