import mmocr
import gradio as gr
import os
from mmocr.utils.ocr import MMOCR


config_dir = os.path.join(
    os.path.dirname(__file__), 'configs/')

# TODO: Put more models on HF hub.
ocr = MMOCR(config_dir=config_dir)


def infer(image):
  # TODO: Also display bounding boxes interactively
  return ocr.readtext(image, output='.', print_result=True, imshow=False)


# TODO: a drop down list for model selection
iface = gr.Interface(fn=infer, inputs="image", outputs="json")
iface.launch()
