def wrap_text(generated_text):
    wrapping_text = ""
    current_line_length = 0
    print(generated_text)
    if "-" in generated_text:
        quote, author = generated_text.split("-")
    elif "―" in generated_text:
        quote, author = generated_text.split("―")
    else:
        quote = generated_text
        author = None
    for word in quote.split(" "):
        if current_line_length >= 20:
            wrapping_text += f"\n{word} "
            current_line_length = len(word)
        else:
            wrapping_text += f"{word} "
            current_line_length += len(word)
    if author is not None:
        wrapping_text += f"\n- {author}"
    return wrapping_text


def compute_text_position(wrapped_text):
    img_height = 1024
    line_height_in_px = 74  # roughly estimated
    margin_bottom = 100  # align text close to the bottom, leaving this many pixels free
    n_lines = wrapped_text.count("\n") + 1
    text_height = n_lines * line_height_in_px
    text_pos = img_height - margin_bottom - text_height
    return text_pos