import gradio as gr
from transformers import pipeline

pipe = pipeline("text-classification", model="nickprock/distilbert-base-uncased-banking77-classification")

dictionary={'LABEL_0':'activate_my_card',
'LABEL_1':'age_limit',
'LABEL_2':'apple_pay_or_google_pay',
'LABEL_3':'atm_support',
'LABEL_4':'automatic_top_up',
'LABEL_5':'balance_not_updated_after_bank_transfer',
'LABEL_6':'balance_not_updated_after_cheque_or_cash_deposit',
'LABEL_7':'beneficiary_not_allowed',
'LABEL_8':'cancel_transfer',
'LABEL_9':'card_about_to_expire',
'LABEL_10':'card_acceptance',
'LABEL_11':'card_arrival',
'LABEL_12':'card_delivery_estimate',
'LABEL_13':'card_linking',
'LABEL_14':'card_not_working',
'LABEL_15':'card_payment_fee_charged',
'LABEL_16':'card_payment_not_recognised',
'LABEL_17':'card_payment_wrong_exchange_rate',
'LABEL_18':'card_swallowed',
'LABEL_19':'cash_withdrawal_charge',
'LABEL_20':'cash_withdrawal_not_recognised',
'LABEL_21':'change_pin',
'LABEL_22':'compromised_card',
'LABEL_23':'contactless_not_working',
'LABEL_24':'country_support',
'LABEL_25':'declined_card_payment',
'LABEL_26':'declined_cash_withdrawal',
'LABEL_27':'declined_transfer',
'LABEL_28':'direct_debit_payment_not_recognised',
'LABEL_29':'disposable_card_limits',
'LABEL_30':'edit_personal_details',
'LABEL_31':'exchange_charge',
'LABEL_32':'exchange_rate',
'LABEL_33':'exchange_via_app',
'LABEL_34':'extra_charge_on_statement',
'LABEL_35':'failed_transfer',
'LABEL_36':'fiat_currency_support',
'LABEL_37':'get_disposable_virtual_card',
'LABEL_38':'get_physical_card',
'LABEL_39':'getting_spare_card',
'LABEL_40':'getting_virtual_card',
'LABEL_41':'lost_or_stolen_card',
'LABEL_42':'lost_or_stolen_phone',
'LABEL_43':'order_physical_card',
'LABEL_44':'passcode_forgotten',
'LABEL_45':'pending_card_payment',
'LABEL_46':'pending_cash_withdrawal',
'LABEL_47':'pending_top_up',
'LABEL_48':'pending_transfer',
'LABEL_49':'pin_blocked',
'LABEL_50':'receiving_money',
'LABEL_51':'Refund_not_showing_up',
'LABEL_52':'request_refund',
'LABEL_53':'reverted_card_payment?',
'LABEL_54':'supported_cards_and_currencies',
'LABEL_55':'terminate_account',
'LABEL_56':'top_up_by_bank_transfer_charge',
'LABEL_57':'top_up_by_card_charge',
'LABEL_58':'top_up_by_cash_or_cheque',
'LABEL_59':'top_up_failed',
'LABEL_60':'top_up_limits',
'LABEL_61':'top_up_reverted',
'LABEL_62':'topping_up_by_card',
'LABEL_63':'transaction_charged_twice',
'LABEL_64':'transfer_fee_charged',
'LABEL_65':'transfer_into_account',
'LABEL_66':'transfer_not_received_by_recipient',
'LABEL_67':'transfer_timing',
'LABEL_68':'unable_to_verify_identity',
'LABEL_69':'verify_my_identity',
'LABEL_70':'verify_source_of_funds',
'LABEL_71':'verify_top_up',
'LABEL_72':'virtual_card_not_working',
'LABEL_73':'visa_or_mastercard',
'LABEL_74':'why_verify_identity',
'LABEL_75':'wrong_amount_of_cash_received',
'LABEL_76':'wrong_exchange_rate_for_cash_withdrawal'}


def greet(text, dictionary=dictionary):
  response = pipe(text)
  return dictionary[response[0]['label']]

demo = gr.Interface(fn=greet, 
  inputs="text", 
  outputs="text", 
  title="Banking Intent Classifier",
  description="Try to classify customer queries",
  examples=[["I can't pay by my credit card"],["Do you have a list of exchange rates?"],["Can I track the card you sent to me?"]],
  cache_examples=False)

demo.launch()