from charset_normalizer import detect
import numpy as np
import gradio as gr
import torch
import torch.nn as nn
import cv2
import os
from numpy import random
from metadata.utils.utils import decodeImage
from metadata.predictor_yolo_detector.detector_test import Detector
from PIL import Image

class ClientApp:
    def __init__(self):
        self.filename = "inputImage.jpg"
        #modelPath = 'research/ssd_mobilenet_v1_coco_2017_11_17'
        self.objectDetection = Detector(self.filename)




clApp = ClientApp()

def predict_image(input_img):

    img = Image.fromarray(input_img)
    img.save("./metadata/predictor_yolo_detector/inference/images/"+ clApp.filename)
    resultant_img = clApp.objectDetection.detect_action()
                                                            
        
    return resultant_img

demo = gr.Blocks()

with demo:
    gr.Markdown(
    """
    <h1 align = "center"> Warehouse Apparel Detection </h1>
    """)
    
    detect = gr.Interface(predict_image, 'image', 'image', examples=[
        os.path.join(os.path.dirname(__file__), "images/image_1.jpg"),
        os.path.join(os.path.dirname(__file__), "images/image_2.jpg"),
        os.path.join(os.path.dirname(__file__), "images/image_3.jpg")
        ])

demo.launch()