---
title: README
emoji: ⚡
colorFrom: pink
colorTo: green
sdk: static
pinned: false
---

<div class="grid lg:grid-cols-2 gap-x-4">
   <h1 class="my-8 lg:col-span-2" style="font-size:20px; font-weight:bold">Announcement: deadline to submit demos was extended to July 24th!</h1>
   <h1 class="my-8 lg:col-span-2" style="font-size:20px; font-weight:bold">EuroPython 2022</h1>
  <p class="lg:col-span-2">EuroPython Dublin, You're invited!</p>
<p class="lg:col-span-2">
Welcome to the 21st EuroPython. We're the oldest and longest running volunteer-led Python programming conference on the planet! Join us in July in the beautiful and vibrant city of Dublin. We'll be together, face to face and online, to celebrate our shared passion for Python and its community!</p>

<h2 class="my-8 lg:col-span-2" style="font-size:20px; font-weight:bold">Hugging Face Gradio Hackathon 🤗 </h2>
<p class="lg:col-span-2">
Come Join us from July 13th to 24th for a Hackathon in person and online using Gradio and Hugging Face to build and host Machine Learning demos. Find tutorial on getting started with Gradio on Hugging Face <a href="https://huggingface.co/course/chapter9/1?fw=pt" style="text-decoration: underline" target="_blank">here</a> and to get started with the new Gradio Blocks API <a href="https://gradio.app/introduction_to_blocks/" style="text-decoration: underline" target="_blank">here</a>. Once the gradio demo is setup, see how to add it to Hugging Face Spaces <a href="https://huggingface.co/docs/hub/spaces-sdks-gradio" style="text-decoration: underline" target="_blank">here</a>. <b>Come see the talk on <a href="https://ep2022.europython.eu/session/how-to-craft-awesome-machine-learning-demos-with-python" style="text-decoration: underline" target="_blank">How to craft awesome Machine Learning demos with Python</a> in Liffey Hall 2 on 13 July 2022 at 14:00 by <a href="https://huggingface.co/osanseviero" style="text-decoration: underline" target="_blank">Omar Sanseviero</a></b></p>

<h3 class="my-8 lg:col-span-2" style="font-size:20px; font-weight:bold">Sprint July 16 and 17</h3>
   <ul class="lg:col-span-2" style="list-style: circle inside;padding-left: 40px;">
      <li class="my-4">Number of people: 3 maintainers + anyone willing to join
</li>
      <li class="my-4">Build Machine Learning demos. You can also join if you don't know much about ML!</li>
      <li class="my-4">Liffey Hall 2</li>
      <li class="my-4">Python Level: any</li>
   </ul>

<h3 class="my-8 lg:col-span-2" style="font-size:20px; font-weight:bold">Join organization by clicking <a href="https://huggingface.co/organizations/EuroPython2022/share/sVhJHDTrJDJkyWTJsRUwTHCSMZYUPlMhUt" style="text-decoration: underline" target="_blank">here</a></h3>

<img class="lg:col-span-2" src="https://i.imgur.com/N6sZ5CI.png" alt="Europython Banner" style="margin:10px">

<h3 class="my-8 lg:col-span-2" style="font-size:20px; font-weight:bold">Potential ideas for creating spaces: </h3>
   <ul class="lg:col-span-2" style="list-style: circle inside;padding-left: 40px;">
      <li class="my-4">Trending papers from <a href="https://paperswithcode.com/" style="text-decoration: underline">https://paperswithcode.com/</a></li>
      <li class="my-4">Models from huggingface model hub: <a href="https://huggingface.co/models" style="text-decoration: underline">https://huggingface.co/models</a></li>
      <li class="my-4">Papers from NAACL 2022 event <a href="https://huggingface.co/NAACL2022" style="text-decoration: underline">https://huggingface.co/NAACL2022</a></li>
      <li class="my-4">Papers from ICML 2022 event <a href="https://huggingface.co/ICML2022" style="text-decoration: underline">https://huggingface.co/ICML2022</a></li>
      <li class="my-4">Hugging Face course event ideas <a href="https://discuss.huggingface.co/c/course/course-event/25" style="text-decoration: underline">https://discuss.huggingface.co/c/course/course-event/25</a></li>
      <li class="my-4">Models from other model hubs
         <ul class="lg:col-span-2" style="list-style: circle inside;padding-left: 40px;">
            <li class="my-4">Tensorflow Hub: see example Gradio demos at <a href="https://huggingface.co/tensorflow" style="text-decoration: underline">https://huggingface.co/tensorflow</a></li>
            <li class="my-4">Pytorch Hub: see example Gradio demos at <a href="https://huggingface.co/pytorch" style="text-decoration: underline">https://huggingface.co/pytorch</a></li>
            <li class="my-4">ONNX model Hub: see example Gradio demos at <a href="https://huggingface.co/onnx" style="text-decoration: underline">https://huggingface.co/onnx</a></li>
            <li class="my-4">PaddlePaddle Model Hub: see example Gradio demos at <a href="https://huggingface.co/PaddlePaddle" style="text-decoration: underline">https://huggingface.co/PaddlePaddle</a></li>
         </ul>
      </li>
      <li class="my-4">Try your own ideas!</li>
   </ul>
   
<h4 class="my-8 lg:col-span-2" style="font-size:20px; font-weight:bold" id="Prizes">Hugging Face Prizes</h4>
<ul class="lg:col-span-2" style="list-style: circle inside">
   <li class="my-4">Top 5 spaces based on likes<ul class="lg:col-span-2" style="list-style: circle inside;padding-left: 40px;">
   <li class="my-4">Swag from <a href="https://huggingface.myshopify.com/">Hugging Face merch shop</a>: t-shirt, hoodie, or mug of your choice</li>
   </ul>
   </li>
</ul>

<h3 class="my-8 lg:col-span-2" style="font-size:20px; font-weight:bold">LeaderBoard for Most Popular EuroPython Spaces</h3>
  <p class="lg:col-span-2">See the <a href="https://huggingface.co/spaces/EuroPython2022/Leaderboard" target="_blank" style="text-decoration:underline; font-weight:bold">EuroPython Leaderboard</a></p>
    <h4 class="my-8 lg:col-span-2" style="font-size:20px; font-weight:bold">Hugging Face Spaces & Gradio for Showcasing your EuroPython ‘22 Demo 
</h4>
   <p class="lg:col-span-2">
   In this tutorial, we will demonstrate how to showcase your demo with an easy to use web interface using the Gradio Python library and host it on Hugging Face Spaces so that conference attendees can easily find and try out your demos. Also, see <a href="https://gradio.app/introduction_to_blocks/" style="text-decoration: underline" target="_blank">https://gradio.app/introduction_to_blocks/</a>, for a more flexible way to build Gradio Demos
   </p>
 <h3 class="my-8 lg:col-span-2" style="font-size:20px; font-weight:bold">🚀 Create a Gradio Demo from your Model
</h3>
<p class="lg:col-span-2">
The first step is to create a web demo from your model. As an example, we will be creating a demo from an image classification model (called model) which we will be uploading to Spaces. The full code for steps 1-4 can be found in this <a href="https://colab.research.google.com/drive/1S6seNoJuU7_-hBX5KbXQV4Fb_bbqdPBk?usp=sharing" style="text-decoration: underline" target="_blank">colab notebook</a>.
</p><br />

<h3 class="my-8 lg:col-span-2" style="font-size:20px; font-weight:bold">1. Install the gradio library
</h3>
<p class="lg:col-span-2">
All you need to do is to run this in the terminal: <code>pip install gradio</code>
</p>
<br />
<h3 class="my-8 lg:col-span-2" style="font-size:20px; font-weight:bold">2. Define a function in your Python code that performs inference with your model on a data point and returns the prediction
</h3>
<p class="lg:col-span-2">
Here’s we define our image classification model prediction function in PyTorch (any framework, like TensorFlow, scikit-learn, JAX, or a plain Python will work as well):
<pre>
<code>
def predict(inp):

        inp = Image.fromarray(inp.astype('uint8'), 'RGB')
      
        inp = transforms.ToTensor()(inp).unsqueeze(0)
      
        with torch.no_grad():

          prediction = torch.nn.functional.softmax(model(inp)[0], dim=0)

        return {labels[i]: float(prediction[i]) for i in range(1000)}
</code>
</pre>
</p>

<h3 class="my-8 lg:col-span-2" style="font-size:20px; font-weight:bold">3. Then create a Gradio Interface using the function and the appropriate input and output types
</h3>
<p class="lg:col-span-2">
For the image classification model from Step 2, it would like like this:
</p>
<pre>
<code>
inputs = gr.inputs.Image()

outputs = gr.outputs.Label(num_top_classes=3)

io = gr.Interface(fn=predict, inputs=inputs, outputs=outputs)
</code>
</pre>
<p class="lg:col-span-2">
If you need help creating a Gradio Interface for your model, check out the Gradio Getting Started guide.
</p>

<h3 class="my-8 lg:col-span-2" style="font-size:20px; font-weight:bold">4. Then launch() you Interface to confirm that it runs correctly locally (or wherever you are running Python)
</h3>
<pre>
<code>
io.launch() 
</code>
</pre>
<p class="lg:col-span-2">
You should see a web interface like the following where you can drag and drop your data points and see the predictions:
</p>
<img class="lg:col-span-2" src="https://i.imgur.com/1hsIgJJ.png" alt="Gradio Interface" style="margin:10px">
</div>







