import pickle
import numpy as np
import gradio as gr
import sklearn
import pandas as pd
from sklearn.model_selection import train_test_split
from sklearn.ensemble import ExtraTreesRegressor

filename = 'Dataset_RCS_3.csv'
names0 = ['JET', "Suelo",'SPT', 'WtoC', 'Presion', 'Velocidad','RCS']
dataset=pd.read_csv(filename, names=names0)

y = dataset['RCS']
X = dataset.drop('RCS', axis=1)

validation_size = 0.20
seed = 10
X_train, X_test, y_train, y_test = train_test_split(X, y, test_size=validation_size, random_state=seed)


modelodef=ExtraTreesRegressor( 
                                     n_estimators=1000,
                                     max_depth=9, 
                                     min_samples_leaf=1,
                                     random_state=seed)
modelodef.fit(X_train, y_train)

pickle.dump(modelodef, open("modelodef.pkl", "wb"))


def RCS(JET, Suelo,SPT, WtoC, Presion, Velocidad):
    modelodef = pickle.load(open("modelodef.pkl", "rb"))
    prediction0 = modelodef.predict([[JET, Suelo,SPT, WtoC, Presion, Velocidad]])
    prediction = np.round(prediction0,2)
    return prediction

title = "ASSESSMENT OF UNIAXIAL COMPRESSIVE STRENGTH OF JET GROUTING"
description = "This app corresponds to the research paper: Assessment of compressive strength of jet grouting by machine learning"
article = """
            Notes:
            - Click submit/enviar button to obtain the UCS prediction
            - Click clear/limpiar button to refresh text
            - Please note the application ranges of the variables in the above-referenced paper (https://doi.org/10.1016/j.jrmge.2023.03.008). Outside these ranges, the predictions may not be reliable
            - As a decimal separator you can use either a point or a comma
           """        
                 
app = gr.Interface(
    RCS,
    inputs=[
        gr.Radio(['1', '2', '3'], label="Jet system.  1: Single.  2: Double.  3: Triple",value="1"),
        gr.Radio(['1', '2', '3', '4'], label="Soil type.  1: Coarse without fines.  2: Coarse with fines.  3: Fine.  4: Organic",value="1"),
        gr.Number(value=1, label="Nspt"),
        gr.Number(value=1, label="W/C"),
        gr.Number(value=1, label="Grout pressure (MPa)"),
        gr.Number(value=1, label="Rotation speed (rpm)"),
        
    ],
    outputs=[gr.Text(label="UCS (MPa)")],
    title=title,
    description=description,
    article = article,
    theme="dark-seafoam"
)

app.launch()